<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lines StructType
 * Meta informations extracted from the WSDL
 * - documentation: Filter the results to include only vehicles along the given LINEs. | Filter the results to include only VEHICLEs along the given LINEs. | Filter the results to include only situations along the given LINEs. | LINEs that use stop.
 * Detail level is 'full'
 * - minOccurs: 0
 * @subpackage Structs
 */
class Lines extends AbstractStructBase
{
    /**
     * The LineDirection
     * Meta informations extracted from the WSDL
     * - documentation: Iinclude only vehicles along the given LINE. | Include only vehicles along the given LINE. | Filter the results to include only the given line. and direction | Reference to a LINE that calls at stop. and its direction +SIRI V2.0
     * - maxOccurs: unbounded
     * @var \StructType\LineDirectionStructure
     */
    public $LineDirection;
    /**
     * The LineRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a LINE that calls at stop.
     * - maxOccurs: 1
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * Constructor method for Lines
     * @uses Lines::setLineDirection()
     * @uses Lines::setLineRef()
     * @param \StructType\LineDirectionStructure $lineDirection
     * @param \StructType\LineRefStructure $lineRef
     */
    public function __construct(\StructType\LineDirectionStructure $lineDirection = null, \StructType\LineRefStructure $lineRef = null)
    {
        $this
            ->setLineDirection($lineDirection)
            ->setLineRef($lineRef);
    }
    /**
     * Get LineDirection value
     * @return \StructType\LineDirectionStructure|null
     */
    public function getLineDirection()
    {
        return $this->LineDirection;
    }
    /**
     * Set LineDirection value
     * @param \StructType\LineDirectionStructure $lineDirection
     * @return \StructType\Lines
     */
    public function setLineDirection(\StructType\LineDirectionStructure $lineDirection = null)
    {
        $this->LineDirection = $lineDirection;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\Lines
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Lines
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
