<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinearTrafficView StructType
 * @subpackage Structs
 */
class LinearTrafficView extends AbstractStructBase
{
    /**
     * The linearPredefinedLocationReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $linearPredefinedLocationReference;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The trafficViewRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TrafficViewRecord[]
     */
    public $trafficViewRecord;
    /**
     * The linearTrafficViewExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $linearTrafficViewExtension;
    /**
     * Constructor method for LinearTrafficView
     * @uses LinearTrafficView::setLinearPredefinedLocationReference()
     * @uses LinearTrafficView::setId()
     * @uses LinearTrafficView::setTrafficViewRecord()
     * @uses LinearTrafficView::setLinearTrafficViewExtension()
     * @param string $linearPredefinedLocationReference
     * @param string $id
     * @param \StructType\TrafficViewRecord[] $trafficViewRecord
     * @param \StructType\ExtensionType $linearTrafficViewExtension
     */
    public function __construct($linearPredefinedLocationReference = null, $id = null, array $trafficViewRecord = array(), \StructType\ExtensionType $linearTrafficViewExtension = null)
    {
        $this
            ->setLinearPredefinedLocationReference($linearPredefinedLocationReference)
            ->setId($id)
            ->setTrafficViewRecord($trafficViewRecord)
            ->setLinearTrafficViewExtension($linearTrafficViewExtension);
    }
    /**
     * Get linearPredefinedLocationReference value
     * @return string
     */
    public function getLinearPredefinedLocationReference()
    {
        return $this->linearPredefinedLocationReference;
    }
    /**
     * Set linearPredefinedLocationReference value
     * @param string $linearPredefinedLocationReference
     * @return \StructType\LinearTrafficView
     */
    public function setLinearPredefinedLocationReference($linearPredefinedLocationReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($linearPredefinedLocationReference) && strlen($linearPredefinedLocationReference) > 1024) || (is_array($linearPredefinedLocationReference) && count($linearPredefinedLocationReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($linearPredefinedLocationReference) ? strlen($linearPredefinedLocationReference) : count($linearPredefinedLocationReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($linearPredefinedLocationReference) && !is_string($linearPredefinedLocationReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linearPredefinedLocationReference)), __LINE__);
        }
        $this->linearPredefinedLocationReference = $linearPredefinedLocationReference;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\LinearTrafficView
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get trafficViewRecord value
     * @return \StructType\TrafficViewRecord[]|null
     */
    public function getTrafficViewRecord()
    {
        return $this->trafficViewRecord;
    }
    /**
     * Set trafficViewRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\TrafficViewRecord[] $trafficViewRecord
     * @return \StructType\LinearTrafficView
     */
    public function setTrafficViewRecord(array $trafficViewRecord = array())
    {
        foreach ($trafficViewRecord as $linearTrafficViewTrafficViewRecordItem) {
            // validation for constraint: itemType
            if (!$linearTrafficViewTrafficViewRecordItem instanceof \StructType\TrafficViewRecord) {
                throw new \InvalidArgumentException(sprintf('The trafficViewRecord property can only contain items of \StructType\TrafficViewRecord, "%s" given', is_object($linearTrafficViewTrafficViewRecordItem) ? get_class($linearTrafficViewTrafficViewRecordItem) : gettype($linearTrafficViewTrafficViewRecordItem)), __LINE__);
            }
        }
        $this->trafficViewRecord = $trafficViewRecord;
        return $this;
    }
    /**
     * Add item to trafficViewRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\TrafficViewRecord $item
     * @return \StructType\LinearTrafficView
     */
    public function addToTrafficViewRecord(\StructType\TrafficViewRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrafficViewRecord) {
            throw new \InvalidArgumentException(sprintf('The trafficViewRecord property can only contain items of \StructType\TrafficViewRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->trafficViewRecord[] = $item;
        return $this;
    }
    /**
     * Get linearTrafficViewExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getLinearTrafficViewExtension()
    {
        return $this->linearTrafficViewExtension;
    }
    /**
     * Set linearTrafficViewExtension value
     * @param \StructType\ExtensionType $linearTrafficViewExtension
     * @return \StructType\LinearTrafficView
     */
    public function setLinearTrafficViewExtension(\StructType\ExtensionType $linearTrafficViewExtension = null)
    {
        $this->linearTrafficViewExtension = $linearTrafficViewExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinearTrafficView
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
