<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinePermissionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Line Permission.
 * @subpackage Structs
 */
class LinePermissionStructure extends AbstractTopicPermissionStructure
{
    /**
     * The LineRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a LINE. whose data participant is allowed to access.
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a DIRECTION of LINE. that participant is allowed to access.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DirectionRefStructure[]
     */
    public $DirectionRef;
    /**
     * Constructor method for LinePermissionStructure
     * @uses LinePermissionStructure::setLineRef()
     * @uses LinePermissionStructure::setDirectionRef()
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure[] $directionRef
     */
    public function __construct(\StructType\LineRefStructure $lineRef = null, array $directionRef = array())
    {
        $this
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef);
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\LinePermissionStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure[]|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectionRefStructure[] $directionRef
     * @return \StructType\LinePermissionStructure
     */
    public function setDirectionRef(array $directionRef = array())
    {
        foreach ($directionRef as $linePermissionStructureDirectionRefItem) {
            // validation for constraint: itemType
            if (!$linePermissionStructureDirectionRefItem instanceof \StructType\DirectionRefStructure) {
                throw new \InvalidArgumentException(sprintf('The DirectionRef property can only contain items of \StructType\DirectionRefStructure, "%s" given', is_object($linePermissionStructureDirectionRefItem) ? get_class($linePermissionStructureDirectionRefItem) : gettype($linePermissionStructureDirectionRefItem)), __LINE__);
            }
        }
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Add item to DirectionRef value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectionRefStructure $item
     * @return \StructType\LinePermissionStructure
     */
    public function addToDirectionRef(\StructType\DirectionRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DirectionRefStructure) {
            throw new \InvalidArgumentException(sprintf('The DirectionRef property can only contain items of \StructType\DirectionRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DirectionRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinePermissionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
