<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Line StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ordered sequence of points. There must always be a start and end point.
 * @subpackage Structs
 */
class Line extends AbstractStructBase
{
    /**
     * The PointProjection
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * - ref: PointProjection
     * @var \StructType\PointProjectionStructure[]
     */
    public $PointProjection;
    /**
     * Constructor method for Line
     * @uses Line::setPointProjection()
     * @param \StructType\PointProjectionStructure[] $pointProjection
     */
    public function __construct(array $pointProjection = array())
    {
        $this
            ->setPointProjection($pointProjection);
    }
    /**
     * Get PointProjection value
     * @return \StructType\PointProjectionStructure[]
     */
    public function getPointProjection()
    {
        return $this->PointProjection;
    }
    /**
     * Set PointProjection value
     * @throws \InvalidArgumentException
     * @param \StructType\PointProjectionStructure[] $pointProjection
     * @return \StructType\Line
     */
    public function setPointProjection(array $pointProjection = array())
    {
        foreach ($pointProjection as $linePointProjectionItem) {
            // validation for constraint: itemType
            if (!$linePointProjectionItem instanceof \StructType\PointProjectionStructure) {
                throw new \InvalidArgumentException(sprintf('The PointProjection property can only contain items of \StructType\PointProjectionStructure, "%s" given', is_object($linePointProjectionItem) ? get_class($linePointProjectionItem) : gettype($linePointProjectionItem)), __LINE__);
            }
        }
        $this->PointProjection = $pointProjection;
        return $this;
    }
    /**
     * Add item to PointProjection value
     * @throws \InvalidArgumentException
     * @param \StructType\PointProjectionStructure $item
     * @return \StructType\Line
     */
    public function addToPointProjection(\StructType\PointProjectionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PointProjectionStructure) {
            throw new \InvalidArgumentException(sprintf('The PointProjection property can only contain items of \StructType\PointProjectionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PointProjection[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Line
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
