<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JourneyParts StructType
 * Meta informations extracted from the WSDL
 * - documentation: JOURNEY PARTs making up JOURNEY +SIRIv2.0 e. | JOURNEY PARTs making up JOURNEY +SIRIv2.0 e.
 * - minOccurs: 0
 * @subpackage Structs
 */
class JourneyParts extends AbstractStructBase
{
    /**
     * The JourneyPartInfo
     * Meta informations extracted from the WSDL
     * - documentation: Information about Parts of JOURNEY +SIRI v2.0 | Information about Parts of JOURNEY +SIRI v2.0
     * - maxOccurs: unbounded
     * @var \StructType\JourneyPartInfoStructure[]
     */
    public $JourneyPartInfo;
    /**
     * Constructor method for JourneyParts
     * @uses JourneyParts::setJourneyPartInfo()
     * @param \StructType\JourneyPartInfoStructure[] $journeyPartInfo
     */
    public function __construct(array $journeyPartInfo = array())
    {
        $this
            ->setJourneyPartInfo($journeyPartInfo);
    }
    /**
     * Get JourneyPartInfo value
     * @return \StructType\JourneyPartInfoStructure[]|null
     */
    public function getJourneyPartInfo()
    {
        return $this->JourneyPartInfo;
    }
    /**
     * Set JourneyPartInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\JourneyPartInfoStructure[] $journeyPartInfo
     * @return \StructType\JourneyParts
     */
    public function setJourneyPartInfo(array $journeyPartInfo = array())
    {
        foreach ($journeyPartInfo as $journeyPartsJourneyPartInfoItem) {
            // validation for constraint: itemType
            if (!$journeyPartsJourneyPartInfoItem instanceof \StructType\JourneyPartInfoStructure) {
                throw new \InvalidArgumentException(sprintf('The JourneyPartInfo property can only contain items of \StructType\JourneyPartInfoStructure, "%s" given', is_object($journeyPartsJourneyPartInfoItem) ? get_class($journeyPartsJourneyPartInfoItem) : gettype($journeyPartsJourneyPartInfoItem)), __LINE__);
            }
        }
        $this->JourneyPartInfo = $journeyPartInfo;
        return $this;
    }
    /**
     * Add item to JourneyPartInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\JourneyPartInfoStructure $item
     * @return \StructType\JourneyParts
     */
    public function addToJourneyPartInfo(\StructType\JourneyPartInfoStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JourneyPartInfoStructure) {
            throw new \InvalidArgumentException(sprintf('The JourneyPartInfo property can only contain items of \StructType\JourneyPartInfoStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JourneyPartInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JourneyParts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
