<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Itinerary StructType
 * @subpackage Structs
 */
class Itinerary extends GroupOfLocations
{
    /**
     * The locationContainedInItinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\LocationContainedInItinerary[]
     */
    public $locationContainedInItinerary;
    /**
     * The routeDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Destination[]
     */
    public $routeDestination;
    /**
     * The itineraryExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $itineraryExtension;
    /**
     * Constructor method for Itinerary
     * @uses Itinerary::setLocationContainedInItinerary()
     * @uses Itinerary::setRouteDestination()
     * @uses Itinerary::setItineraryExtension()
     * @param \StructType\LocationContainedInItinerary[] $locationContainedInItinerary
     * @param \StructType\Destination[] $routeDestination
     * @param \StructType\ExtensionType $itineraryExtension
     */
    public function __construct(array $locationContainedInItinerary = array(), array $routeDestination = array(), \StructType\ExtensionType $itineraryExtension = null)
    {
        $this
            ->setLocationContainedInItinerary($locationContainedInItinerary)
            ->setRouteDestination($routeDestination)
            ->setItineraryExtension($itineraryExtension);
    }
    /**
     * Get locationContainedInItinerary value
     * @return \StructType\LocationContainedInItinerary[]
     */
    public function getLocationContainedInItinerary()
    {
        return $this->locationContainedInItinerary;
    }
    /**
     * Set locationContainedInItinerary value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationContainedInItinerary[] $locationContainedInItinerary
     * @return \StructType\Itinerary
     */
    public function setLocationContainedInItinerary(array $locationContainedInItinerary = array())
    {
        foreach ($locationContainedInItinerary as $itineraryLocationContainedInItineraryItem) {
            // validation for constraint: itemType
            if (!$itineraryLocationContainedInItineraryItem instanceof \StructType\LocationContainedInItinerary) {
                throw new \InvalidArgumentException(sprintf('The locationContainedInItinerary property can only contain items of \StructType\LocationContainedInItinerary, "%s" given', is_object($itineraryLocationContainedInItineraryItem) ? get_class($itineraryLocationContainedInItineraryItem) : gettype($itineraryLocationContainedInItineraryItem)), __LINE__);
            }
        }
        $this->locationContainedInItinerary = $locationContainedInItinerary;
        return $this;
    }
    /**
     * Add item to locationContainedInItinerary value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationContainedInItinerary $item
     * @return \StructType\Itinerary
     */
    public function addToLocationContainedInItinerary(\StructType\LocationContainedInItinerary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationContainedInItinerary) {
            throw new \InvalidArgumentException(sprintf('The locationContainedInItinerary property can only contain items of \StructType\LocationContainedInItinerary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->locationContainedInItinerary[] = $item;
        return $this;
    }
    /**
     * Get routeDestination value
     * @return \StructType\Destination[]|null
     */
    public function getRouteDestination()
    {
        return $this->routeDestination;
    }
    /**
     * Set routeDestination value
     * @throws \InvalidArgumentException
     * @param \StructType\Destination[] $routeDestination
     * @return \StructType\Itinerary
     */
    public function setRouteDestination(array $routeDestination = array())
    {
        foreach ($routeDestination as $itineraryRouteDestinationItem) {
            // validation for constraint: itemType
            if (!$itineraryRouteDestinationItem instanceof \StructType\Destination) {
                throw new \InvalidArgumentException(sprintf('The routeDestination property can only contain items of \StructType\Destination, "%s" given', is_object($itineraryRouteDestinationItem) ? get_class($itineraryRouteDestinationItem) : gettype($itineraryRouteDestinationItem)), __LINE__);
            }
        }
        $this->routeDestination = $routeDestination;
        return $this;
    }
    /**
     * Add item to routeDestination value
     * @throws \InvalidArgumentException
     * @param \StructType\Destination $item
     * @return \StructType\Itinerary
     */
    public function addToRouteDestination(\StructType\Destination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Destination) {
            throw new \InvalidArgumentException(sprintf('The routeDestination property can only contain items of \StructType\Destination, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->routeDestination[] = $item;
        return $this;
    }
    /**
     * Get itineraryExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getItineraryExtension()
    {
        return $this->itineraryExtension;
    }
    /**
     * Set itineraryExtension value
     * @param \StructType\ExtensionType $itineraryExtension
     * @return \StructType\Itinerary
     */
    public function setItineraryExtension(\StructType\ExtensionType $itineraryExtension = null)
    {
        $this->itineraryExtension = $itineraryExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Itinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
