<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InternationalIdentifier StructType
 * @subpackage Structs
 */
class InternationalIdentifier extends AbstractStructBase
{
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The nationalIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $nationalIdentifier;
    /**
     * The internationalIdentifierExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $internationalIdentifierExtension;
    /**
     * Constructor method for InternationalIdentifier
     * @uses InternationalIdentifier::setCountry()
     * @uses InternationalIdentifier::setNationalIdentifier()
     * @uses InternationalIdentifier::setInternationalIdentifierExtension()
     * @param string $country
     * @param string $nationalIdentifier
     * @param \StructType\ExtensionType $internationalIdentifierExtension
     */
    public function __construct($country = null, $nationalIdentifier = null, \StructType\ExtensionType $internationalIdentifierExtension = null)
    {
        $this
            ->setCountry($country)
            ->setNationalIdentifier($nationalIdentifier)
            ->setInternationalIdentifierExtension($internationalIdentifierExtension);
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @uses \EnumType\CountryEnum::valueIsValid()
     * @uses \EnumType\CountryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\InternationalIdentifier
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryEnum::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $country, implode(', ', \EnumType\CountryEnum::getValidValues())), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get nationalIdentifier value
     * @return string
     */
    public function getNationalIdentifier()
    {
        return $this->nationalIdentifier;
    }
    /**
     * Set nationalIdentifier value
     * @param string $nationalIdentifier
     * @return \StructType\InternationalIdentifier
     */
    public function setNationalIdentifier($nationalIdentifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nationalIdentifier) && strlen($nationalIdentifier) > 1024) || (is_array($nationalIdentifier) && count($nationalIdentifier) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($nationalIdentifier) ? strlen($nationalIdentifier) : count($nationalIdentifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nationalIdentifier) && !is_string($nationalIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalIdentifier)), __LINE__);
        }
        $this->nationalIdentifier = $nationalIdentifier;
        return $this;
    }
    /**
     * Get internationalIdentifierExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getInternationalIdentifierExtension()
    {
        return $this->internationalIdentifierExtension;
    }
    /**
     * Set internationalIdentifierExtension value
     * @param \StructType\ExtensionType $internationalIdentifierExtension
     * @return \StructType\InternationalIdentifier
     */
    public function setInternationalIdentifierExtension(\StructType\ExtensionType $internationalIdentifierExtension = null)
    {
        $this->internationalIdentifierExtension = $internationalIdentifierExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InternationalIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
