<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfrastructureDamageObstruction StructType
 * @subpackage Structs
 */
class InfrastructureDamageObstruction extends Obstruction
{
    /**
     * The infrastructureDamageType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $infrastructureDamageType;
    /**
     * The infrastructureDamageObstructionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $infrastructureDamageObstructionExtension;
    /**
     * Constructor method for InfrastructureDamageObstruction
     * @uses InfrastructureDamageObstruction::setInfrastructureDamageType()
     * @uses InfrastructureDamageObstruction::setInfrastructureDamageObstructionExtension()
     * @param string $infrastructureDamageType
     * @param \StructType\ExtensionType $infrastructureDamageObstructionExtension
     */
    public function __construct($infrastructureDamageType = null, \StructType\ExtensionType $infrastructureDamageObstructionExtension = null)
    {
        $this
            ->setInfrastructureDamageType($infrastructureDamageType)
            ->setInfrastructureDamageObstructionExtension($infrastructureDamageObstructionExtension);
    }
    /**
     * Get infrastructureDamageType value
     * @return string
     */
    public function getInfrastructureDamageType()
    {
        return $this->infrastructureDamageType;
    }
    /**
     * Set infrastructureDamageType value
     * @uses \EnumType\InfrastructureDamageTypeEnum::valueIsValid()
     * @uses \EnumType\InfrastructureDamageTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $infrastructureDamageType
     * @return \StructType\InfrastructureDamageObstruction
     */
    public function setInfrastructureDamageType($infrastructureDamageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InfrastructureDamageTypeEnum::valueIsValid($infrastructureDamageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $infrastructureDamageType, implode(', ', \EnumType\InfrastructureDamageTypeEnum::getValidValues())), __LINE__);
        }
        $this->infrastructureDamageType = $infrastructureDamageType;
        return $this;
    }
    /**
     * Get infrastructureDamageObstructionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getInfrastructureDamageObstructionExtension()
    {
        return $this->infrastructureDamageObstructionExtension;
    }
    /**
     * Set infrastructureDamageObstructionExtension value
     * @param \StructType\ExtensionType $infrastructureDamageObstructionExtension
     * @return \StructType\InfrastructureDamageObstruction
     */
    public function setInfrastructureDamageObstructionExtension(\StructType\ExtensionType $infrastructureDamageObstructionExtension = null)
    {
        $this->infrastructureDamageObstructionExtension = $infrastructureDamageObstructionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfrastructureDamageObstruction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
