<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoLinksStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for collection of info links.
 * @subpackage Structs
 */
class InfoLinksStructure extends AbstractStructBase
{
    /**
     * The InfoLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: InfoLink
     * @var \StructType\InfoLinkStructure[]
     */
    public $InfoLink;
    /**
     * Constructor method for InfoLinksStructure
     * @uses InfoLinksStructure::setInfoLink()
     * @param \StructType\InfoLinkStructure[] $infoLink
     */
    public function __construct(array $infoLink = array())
    {
        $this
            ->setInfoLink($infoLink);
    }
    /**
     * Get InfoLink value
     * @return \StructType\InfoLinkStructure[]|null
     */
    public function getInfoLink()
    {
        return $this->InfoLink;
    }
    /**
     * Set InfoLink value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoLinkStructure[] $infoLink
     * @return \StructType\InfoLinksStructure
     */
    public function setInfoLink(array $infoLink = array())
    {
        foreach ($infoLink as $infoLinksStructureInfoLinkItem) {
            // validation for constraint: itemType
            if (!$infoLinksStructureInfoLinkItem instanceof \StructType\InfoLinkStructure) {
                throw new \InvalidArgumentException(sprintf('The InfoLink property can only contain items of \StructType\InfoLinkStructure, "%s" given', is_object($infoLinksStructureInfoLinkItem) ? get_class($infoLinksStructureInfoLinkItem) : gettype($infoLinksStructureInfoLinkItem)), __LINE__);
            }
        }
        $this->InfoLink = $infoLink;
        return $this;
    }
    /**
     * Add item to InfoLink value
     * @throws \InvalidArgumentException
     * @param \StructType\InfoLinkStructure $item
     * @return \StructType\InfoLinksStructure
     */
    public function addToInfoLink(\StructType\InfoLinkStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InfoLinkStructure) {
            throw new \InvalidArgumentException(sprintf('The InfoLink property can only contain items of \StructType\InfoLinkStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InfoLink[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoLinksStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
