<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoChannelStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Info Channels description.
 * @subpackage Structs
 */
class InfoChannelStructure extends AbstractStructBase
{
    /**
     * The InfoChannelCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of classification. | Type for identifier of an Info Channel.
     * @var string
     */
    public $InfoChannelCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Name of Info Channel.
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $Name;
    /**
     * The Icon
     * Meta informations extracted from the WSDL
     * - documentation: Icon associated with Info Channel.
     * @var string
     */
    public $Icon;
    /**
     * Constructor method for InfoChannelStructure
     * @uses InfoChannelStructure::setInfoChannelCode()
     * @uses InfoChannelStructure::setName()
     * @uses InfoChannelStructure::setIcon()
     * @param string $infoChannelCode
     * @param \StructType\NaturalLanguageStringStructure $name
     * @param string $icon
     */
    public function __construct($infoChannelCode = null, \StructType\NaturalLanguageStringStructure $name = null, $icon = null)
    {
        $this
            ->setInfoChannelCode($infoChannelCode)
            ->setName($name)
            ->setIcon($icon);
    }
    /**
     * Get InfoChannelCode value
     * @return string|null
     */
    public function getInfoChannelCode()
    {
        return $this->InfoChannelCode;
    }
    /**
     * Set InfoChannelCode value
     * @param string $infoChannelCode
     * @return \StructType\InfoChannelStructure
     */
    public function setInfoChannelCode($infoChannelCode = null)
    {
        // validation for constraint: string
        if (!is_null($infoChannelCode) && !is_string($infoChannelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoChannelCode)), __LINE__);
        }
        $this->InfoChannelCode = $infoChannelCode;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\NaturalLanguageStringStructure $name
     * @return \StructType\InfoChannelStructure
     */
    public function setName(\StructType\NaturalLanguageStringStructure $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Icon value
     * @return string|null
     */
    public function getIcon()
    {
        return $this->Icon;
    }
    /**
     * Set Icon value
     * @param string $icon
     * @return \StructType\InfoChannelStructure
     */
    public function setIcon($icon = null)
    {
        // validation for constraint: string
        if (!is_null($icon) && !is_string($icon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icon)), __LINE__);
        }
        $this->Icon = $icon;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoChannelStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
