<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Images StructType
 * Meta informations extracted from the WSDL
 * - documentation: Any images associated with SITUATION.
 * - minOccurs: 0
 * @subpackage Structs
 */
class Images extends AbstractStructBase
{
    /**
     * The Image
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Image[]
     */
    public $Image;
    /**
     * Constructor method for Images
     * @uses Images::setImage()
     * @param \StructType\Image[] $image
     */
    public function __construct(array $image = array())
    {
        $this
            ->setImage($image);
    }
    /**
     * Get Image value
     * @return \StructType\Image[]|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @throws \InvalidArgumentException
     * @param \StructType\Image[] $image
     * @return \StructType\Images
     */
    public function setImage(array $image = array())
    {
        foreach ($image as $imagesImageItem) {
            // validation for constraint: itemType
            if (!$imagesImageItem instanceof \StructType\Image) {
                throw new \InvalidArgumentException(sprintf('The Image property can only contain items of \StructType\Image, "%s" given', is_object($imagesImageItem) ? get_class($imagesImageItem) : gettype($imagesImageItem)), __LINE__);
            }
        }
        $this->Image = $image;
        return $this;
    }
    /**
     * Add item to Image value
     * @throws \InvalidArgumentException
     * @param \StructType\Image $item
     * @return \StructType\Images
     */
    public function addToImage(\StructType\Image $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Image) {
            throw new \InvalidArgumentException(sprintf('The Image property can only contain items of \StructType\Image, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Image[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Images
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
