<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for image.
 * @subpackage Structs
 */
class ImageStructure extends AbstractStructBase
{
    /**
     * The ImageRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to an image.
     * @var string
     */
    public $ImageRef;
    /**
     * The ImageBinary
     * Meta informations extracted from the WSDL
     * - documentation: Embedded image.
     * @var string
     */
    public $ImageBinary;
    /**
     * The ImageContent
     * Meta informations extracted from the WSDL
     * - documentation: Categorisation of image content.
     * - minOccurs: 0
     * @var string
     */
    public $ImageContent;
    /**
     * Constructor method for ImageStructure
     * @uses ImageStructure::setImageRef()
     * @uses ImageStructure::setImageBinary()
     * @uses ImageStructure::setImageContent()
     * @param string $imageRef
     * @param string $imageBinary
     * @param string $imageContent
     */
    public function __construct($imageRef = null, $imageBinary = null, $imageContent = null)
    {
        $this
            ->setImageRef($imageRef)
            ->setImageBinary($imageBinary)
            ->setImageContent($imageContent);
    }
    /**
     * Get ImageRef value
     * @return string|null
     */
    public function getImageRef()
    {
        return $this->ImageRef;
    }
    /**
     * Set ImageRef value
     * @param string $imageRef
     * @return \StructType\ImageStructure
     */
    public function setImageRef($imageRef = null)
    {
        // validation for constraint: string
        if (!is_null($imageRef) && !is_string($imageRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageRef)), __LINE__);
        }
        $this->ImageRef = $imageRef;
        return $this;
    }
    /**
     * Get ImageBinary value
     * @return string|null
     */
    public function getImageBinary()
    {
        return $this->ImageBinary;
    }
    /**
     * Set ImageBinary value
     * @param string $imageBinary
     * @return \StructType\ImageStructure
     */
    public function setImageBinary($imageBinary = null)
    {
        // validation for constraint: string
        if (!is_null($imageBinary) && !is_string($imageBinary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageBinary)), __LINE__);
        }
        $this->ImageBinary = $imageBinary;
        return $this;
    }
    /**
     * Get ImageContent value
     * @return string|null
     */
    public function getImageContent()
    {
        return $this->ImageContent;
    }
    /**
     * Set ImageContent value
     * @uses \EnumType\ImageContentEnumeration::valueIsValid()
     * @uses \EnumType\ImageContentEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imageContent
     * @return \StructType\ImageStructure
     */
    public function setImageContent($imageContent = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImageContentEnumeration::valueIsValid($imageContent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $imageContent, implode(', ', \EnumType\ImageContentEnumeration::getValidValues())), __LINE__);
        }
        $this->ImageContent = $imageContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ImageStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
