<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HumidityInformation StructType
 * @subpackage Structs
 */
class HumidityInformation extends WeatherValue
{
    /**
     * The humidity
     * @var \StructType\Humidity
     */
    public $humidity;
    /**
     * The humidityInformationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $humidityInformationExtension;
    /**
     * Constructor method for HumidityInformation
     * @uses HumidityInformation::setHumidity()
     * @uses HumidityInformation::setHumidityInformationExtension()
     * @param \StructType\Humidity $humidity
     * @param \StructType\ExtensionType $humidityInformationExtension
     */
    public function __construct(\StructType\Humidity $humidity = null, \StructType\ExtensionType $humidityInformationExtension = null)
    {
        $this
            ->setHumidity($humidity)
            ->setHumidityInformationExtension($humidityInformationExtension);
    }
    /**
     * Get humidity value
     * @return \StructType\Humidity|null
     */
    public function getHumidity()
    {
        return $this->humidity;
    }
    /**
     * Set humidity value
     * @param \StructType\Humidity $humidity
     * @return \StructType\HumidityInformation
     */
    public function setHumidity(\StructType\Humidity $humidity = null)
    {
        $this->humidity = $humidity;
        return $this;
    }
    /**
     * Get humidityInformationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getHumidityInformationExtension()
    {
        return $this->humidityInformationExtension;
    }
    /**
     * Set humidityInformationExtension value
     * @param \StructType\ExtensionType $humidityInformationExtension
     * @return \StructType\HumidityInformation
     */
    public function setHumidityInformationExtension(\StructType\ExtensionType $humidityInformationExtension = null)
    {
        $this->humidityInformationExtension = $humidityInformationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HumidityInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
