<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HeaderInformation StructType
 * @subpackage Structs
 */
class HeaderInformation extends AbstractStructBase
{
    /**
     * The confidentiality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $confidentiality;
    /**
     * The informationStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $informationStatus;
    /**
     * The areaOfInterest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $areaOfInterest;
    /**
     * The urgency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urgency;
    /**
     * The headerInformationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $headerInformationExtension;
    /**
     * Constructor method for HeaderInformation
     * @uses HeaderInformation::setConfidentiality()
     * @uses HeaderInformation::setInformationStatus()
     * @uses HeaderInformation::setAreaOfInterest()
     * @uses HeaderInformation::setUrgency()
     * @uses HeaderInformation::setHeaderInformationExtension()
     * @param string $confidentiality
     * @param string $informationStatus
     * @param string $areaOfInterest
     * @param string $urgency
     * @param \StructType\ExtensionType $headerInformationExtension
     */
    public function __construct($confidentiality = null, $informationStatus = null, $areaOfInterest = null, $urgency = null, \StructType\ExtensionType $headerInformationExtension = null)
    {
        $this
            ->setConfidentiality($confidentiality)
            ->setInformationStatus($informationStatus)
            ->setAreaOfInterest($areaOfInterest)
            ->setUrgency($urgency)
            ->setHeaderInformationExtension($headerInformationExtension);
    }
    /**
     * Get confidentiality value
     * @return string
     */
    public function getConfidentiality()
    {
        return $this->confidentiality;
    }
    /**
     * Set confidentiality value
     * @uses \EnumType\ConfidentialityValueEnum::valueIsValid()
     * @uses \EnumType\ConfidentialityValueEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confidentiality
     * @return \StructType\HeaderInformation
     */
    public function setConfidentiality($confidentiality = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConfidentialityValueEnum::valueIsValid($confidentiality)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $confidentiality, implode(', ', \EnumType\ConfidentialityValueEnum::getValidValues())), __LINE__);
        }
        $this->confidentiality = $confidentiality;
        return $this;
    }
    /**
     * Get informationStatus value
     * @return string
     */
    public function getInformationStatus()
    {
        return $this->informationStatus;
    }
    /**
     * Set informationStatus value
     * @uses \EnumType\InformationStatusEnum::valueIsValid()
     * @uses \EnumType\InformationStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $informationStatus
     * @return \StructType\HeaderInformation
     */
    public function setInformationStatus($informationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InformationStatusEnum::valueIsValid($informationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $informationStatus, implode(', ', \EnumType\InformationStatusEnum::getValidValues())), __LINE__);
        }
        $this->informationStatus = $informationStatus;
        return $this;
    }
    /**
     * Get areaOfInterest value
     * @return string|null
     */
    public function getAreaOfInterest()
    {
        return $this->areaOfInterest;
    }
    /**
     * Set areaOfInterest value
     * @uses \EnumType\AreaOfInterestEnum::valueIsValid()
     * @uses \EnumType\AreaOfInterestEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $areaOfInterest
     * @return \StructType\HeaderInformation
     */
    public function setAreaOfInterest($areaOfInterest = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AreaOfInterestEnum::valueIsValid($areaOfInterest)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $areaOfInterest, implode(', ', \EnumType\AreaOfInterestEnum::getValidValues())), __LINE__);
        }
        $this->areaOfInterest = $areaOfInterest;
        return $this;
    }
    /**
     * Get urgency value
     * @return string|null
     */
    public function getUrgency()
    {
        return $this->urgency;
    }
    /**
     * Set urgency value
     * @uses \EnumType\UrgencyEnum::valueIsValid()
     * @uses \EnumType\UrgencyEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urgency
     * @return \StructType\HeaderInformation
     */
    public function setUrgency($urgency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UrgencyEnum::valueIsValid($urgency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $urgency, implode(', ', \EnumType\UrgencyEnum::getValidValues())), __LINE__);
        }
        $this->urgency = $urgency;
        return $this;
    }
    /**
     * Get headerInformationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getHeaderInformationExtension()
    {
        return $this->headerInformationExtension;
    }
    /**
     * Set headerInformationExtension value
     * @param \StructType\ExtensionType $headerInformationExtension
     * @return \StructType\HeaderInformation
     */
    public function setHeaderInformationExtension(\StructType\ExtensionType $headerInformationExtension = null)
    {
        $this->headerInformationExtension = $headerInformationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HeaderInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
