<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HazardousMaterials StructType
 * @subpackage Structs
 */
class HazardousMaterials extends AbstractStructBase
{
    /**
     * The chemicalName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\MultilingualString
     */
    public $chemicalName;
    /**
     * The dangerousGoodsFlashPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $dangerousGoodsFlashPoint;
    /**
     * The dangerousGoodsRegulations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dangerousGoodsRegulations;
    /**
     * The hazardCodeIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $hazardCodeIdentification;
    /**
     * The hazardCodeVersionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $hazardCodeVersionNumber;
    /**
     * The hazardSubstanceItemPageNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $hazardSubstanceItemPageNumber;
    /**
     * The tremCardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $tremCardNumber;
    /**
     * The undgNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $undgNumber;
    /**
     * The volumeOfDangerousGoods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $volumeOfDangerousGoods;
    /**
     * The weightOfDangerousGoods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $weightOfDangerousGoods;
    /**
     * The hazardousMaterialsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $hazardousMaterialsExtension;
    /**
     * Constructor method for HazardousMaterials
     * @uses HazardousMaterials::setChemicalName()
     * @uses HazardousMaterials::setDangerousGoodsFlashPoint()
     * @uses HazardousMaterials::setDangerousGoodsRegulations()
     * @uses HazardousMaterials::setHazardCodeIdentification()
     * @uses HazardousMaterials::setHazardCodeVersionNumber()
     * @uses HazardousMaterials::setHazardSubstanceItemPageNumber()
     * @uses HazardousMaterials::setTremCardNumber()
     * @uses HazardousMaterials::setUndgNumber()
     * @uses HazardousMaterials::setVolumeOfDangerousGoods()
     * @uses HazardousMaterials::setWeightOfDangerousGoods()
     * @uses HazardousMaterials::setHazardousMaterialsExtension()
     * @param \StructType\MultilingualString $chemicalName
     * @param float $dangerousGoodsFlashPoint
     * @param string $dangerousGoodsRegulations
     * @param string $hazardCodeIdentification
     * @param int $hazardCodeVersionNumber
     * @param string $hazardSubstanceItemPageNumber
     * @param string $tremCardNumber
     * @param string $undgNumber
     * @param float $volumeOfDangerousGoods
     * @param float $weightOfDangerousGoods
     * @param \StructType\ExtensionType $hazardousMaterialsExtension
     */
    public function __construct(\StructType\MultilingualString $chemicalName = null, $dangerousGoodsFlashPoint = null, $dangerousGoodsRegulations = null, $hazardCodeIdentification = null, $hazardCodeVersionNumber = null, $hazardSubstanceItemPageNumber = null, $tremCardNumber = null, $undgNumber = null, $volumeOfDangerousGoods = null, $weightOfDangerousGoods = null, \StructType\ExtensionType $hazardousMaterialsExtension = null)
    {
        $this
            ->setChemicalName($chemicalName)
            ->setDangerousGoodsFlashPoint($dangerousGoodsFlashPoint)
            ->setDangerousGoodsRegulations($dangerousGoodsRegulations)
            ->setHazardCodeIdentification($hazardCodeIdentification)
            ->setHazardCodeVersionNumber($hazardCodeVersionNumber)
            ->setHazardSubstanceItemPageNumber($hazardSubstanceItemPageNumber)
            ->setTremCardNumber($tremCardNumber)
            ->setUndgNumber($undgNumber)
            ->setVolumeOfDangerousGoods($volumeOfDangerousGoods)
            ->setWeightOfDangerousGoods($weightOfDangerousGoods)
            ->setHazardousMaterialsExtension($hazardousMaterialsExtension);
    }
    /**
     * Get chemicalName value
     * @return \StructType\MultilingualString
     */
    public function getChemicalName()
    {
        return $this->chemicalName;
    }
    /**
     * Set chemicalName value
     * @param \StructType\MultilingualString $chemicalName
     * @return \StructType\HazardousMaterials
     */
    public function setChemicalName(\StructType\MultilingualString $chemicalName = null)
    {
        $this->chemicalName = $chemicalName;
        return $this;
    }
    /**
     * Get dangerousGoodsFlashPoint value
     * @return float|null
     */
    public function getDangerousGoodsFlashPoint()
    {
        return $this->dangerousGoodsFlashPoint;
    }
    /**
     * Set dangerousGoodsFlashPoint value
     * @param float $dangerousGoodsFlashPoint
     * @return \StructType\HazardousMaterials
     */
    public function setDangerousGoodsFlashPoint($dangerousGoodsFlashPoint = null)
    {
        $this->dangerousGoodsFlashPoint = $dangerousGoodsFlashPoint;
        return $this;
    }
    /**
     * Get dangerousGoodsRegulations value
     * @return string|null
     */
    public function getDangerousGoodsRegulations()
    {
        return $this->dangerousGoodsRegulations;
    }
    /**
     * Set dangerousGoodsRegulations value
     * @uses \EnumType\DangerousGoodsRegulationsEnum::valueIsValid()
     * @uses \EnumType\DangerousGoodsRegulationsEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dangerousGoodsRegulations
     * @return \StructType\HazardousMaterials
     */
    public function setDangerousGoodsRegulations($dangerousGoodsRegulations = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DangerousGoodsRegulationsEnum::valueIsValid($dangerousGoodsRegulations)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dangerousGoodsRegulations, implode(', ', \EnumType\DangerousGoodsRegulationsEnum::getValidValues())), __LINE__);
        }
        $this->dangerousGoodsRegulations = $dangerousGoodsRegulations;
        return $this;
    }
    /**
     * Get hazardCodeIdentification value
     * @return string|null
     */
    public function getHazardCodeIdentification()
    {
        return $this->hazardCodeIdentification;
    }
    /**
     * Set hazardCodeIdentification value
     * @param string $hazardCodeIdentification
     * @return \StructType\HazardousMaterials
     */
    public function setHazardCodeIdentification($hazardCodeIdentification = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hazardCodeIdentification) && strlen($hazardCodeIdentification) > 1024) || (is_array($hazardCodeIdentification) && count($hazardCodeIdentification) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($hazardCodeIdentification) ? strlen($hazardCodeIdentification) : count($hazardCodeIdentification)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hazardCodeIdentification) && !is_string($hazardCodeIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hazardCodeIdentification)), __LINE__);
        }
        $this->hazardCodeIdentification = $hazardCodeIdentification;
        return $this;
    }
    /**
     * Get hazardCodeVersionNumber value
     * @return int|null
     */
    public function getHazardCodeVersionNumber()
    {
        return $this->hazardCodeVersionNumber;
    }
    /**
     * Set hazardCodeVersionNumber value
     * @param int $hazardCodeVersionNumber
     * @return \StructType\HazardousMaterials
     */
    public function setHazardCodeVersionNumber($hazardCodeVersionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($hazardCodeVersionNumber) && !is_numeric($hazardCodeVersionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hazardCodeVersionNumber)), __LINE__);
        }
        $this->hazardCodeVersionNumber = $hazardCodeVersionNumber;
        return $this;
    }
    /**
     * Get hazardSubstanceItemPageNumber value
     * @return string|null
     */
    public function getHazardSubstanceItemPageNumber()
    {
        return $this->hazardSubstanceItemPageNumber;
    }
    /**
     * Set hazardSubstanceItemPageNumber value
     * @param string $hazardSubstanceItemPageNumber
     * @return \StructType\HazardousMaterials
     */
    public function setHazardSubstanceItemPageNumber($hazardSubstanceItemPageNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hazardSubstanceItemPageNumber) && strlen($hazardSubstanceItemPageNumber) > 1024) || (is_array($hazardSubstanceItemPageNumber) && count($hazardSubstanceItemPageNumber) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($hazardSubstanceItemPageNumber) ? strlen($hazardSubstanceItemPageNumber) : count($hazardSubstanceItemPageNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hazardSubstanceItemPageNumber) && !is_string($hazardSubstanceItemPageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hazardSubstanceItemPageNumber)), __LINE__);
        }
        $this->hazardSubstanceItemPageNumber = $hazardSubstanceItemPageNumber;
        return $this;
    }
    /**
     * Get tremCardNumber value
     * @return string|null
     */
    public function getTremCardNumber()
    {
        return $this->tremCardNumber;
    }
    /**
     * Set tremCardNumber value
     * @param string $tremCardNumber
     * @return \StructType\HazardousMaterials
     */
    public function setTremCardNumber($tremCardNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tremCardNumber) && strlen($tremCardNumber) > 1024) || (is_array($tremCardNumber) && count($tremCardNumber) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($tremCardNumber) ? strlen($tremCardNumber) : count($tremCardNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tremCardNumber) && !is_string($tremCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tremCardNumber)), __LINE__);
        }
        $this->tremCardNumber = $tremCardNumber;
        return $this;
    }
    /**
     * Get undgNumber value
     * @return string|null
     */
    public function getUndgNumber()
    {
        return $this->undgNumber;
    }
    /**
     * Set undgNumber value
     * @param string $undgNumber
     * @return \StructType\HazardousMaterials
     */
    public function setUndgNumber($undgNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($undgNumber) && strlen($undgNumber) > 1024) || (is_array($undgNumber) && count($undgNumber) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($undgNumber) ? strlen($undgNumber) : count($undgNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($undgNumber) && !is_string($undgNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($undgNumber)), __LINE__);
        }
        $this->undgNumber = $undgNumber;
        return $this;
    }
    /**
     * Get volumeOfDangerousGoods value
     * @return float|null
     */
    public function getVolumeOfDangerousGoods()
    {
        return $this->volumeOfDangerousGoods;
    }
    /**
     * Set volumeOfDangerousGoods value
     * @param float $volumeOfDangerousGoods
     * @return \StructType\HazardousMaterials
     */
    public function setVolumeOfDangerousGoods($volumeOfDangerousGoods = null)
    {
        $this->volumeOfDangerousGoods = $volumeOfDangerousGoods;
        return $this;
    }
    /**
     * Get weightOfDangerousGoods value
     * @return float|null
     */
    public function getWeightOfDangerousGoods()
    {
        return $this->weightOfDangerousGoods;
    }
    /**
     * Set weightOfDangerousGoods value
     * @param float $weightOfDangerousGoods
     * @return \StructType\HazardousMaterials
     */
    public function setWeightOfDangerousGoods($weightOfDangerousGoods = null)
    {
        $this->weightOfDangerousGoods = $weightOfDangerousGoods;
        return $this;
    }
    /**
     * Get hazardousMaterialsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getHazardousMaterialsExtension()
    {
        return $this->hazardousMaterialsExtension;
    }
    /**
     * Set hazardousMaterialsExtension value
     * @param \StructType\ExtensionType $hazardousMaterialsExtension
     * @return \StructType\HazardousMaterials
     */
    public function setHazardousMaterialsExtension(\StructType\ExtensionType $hazardousMaterialsExtension = null)
    {
        $this->hazardousMaterialsExtension = $hazardousMaterialsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HazardousMaterials
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
