<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HalfOpenTimestampInputRangeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a range of date times. Start time must be specified, end time is optional.
 * @subpackage Structs
 */
class HalfOpenTimestampInputRangeStructure extends AbstractStructBase
{
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - documentation: The (inclusive) start time stamp.
     * @var string
     */
    public $StartTime;
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - documentation: The (inclusive) end time stamp.
     * - minOccurs: 0
     * @var string
     */
    public $EndTime;
    /**
     * The EndTimePrecision
     * Meta informations extracted from the WSDL
     * - default: second
     * - documentation: Precision with which to interpret the inclusive end time. Default is to the second. (Siri 2.0++)
     * - minOccurs: 0
     * @var string
     */
    public $EndTimePrecision;
    /**
     * Constructor method for HalfOpenTimestampInputRangeStructure
     * @uses HalfOpenTimestampInputRangeStructure::setStartTime()
     * @uses HalfOpenTimestampInputRangeStructure::setEndTime()
     * @uses HalfOpenTimestampInputRangeStructure::setEndTimePrecision()
     * @param string $startTime
     * @param string $endTime
     * @param string $endTimePrecision
     */
    public function __construct($startTime = null, $endTime = null, $endTimePrecision = 'second')
    {
        $this
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setEndTimePrecision($endTimePrecision);
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\HalfOpenTimestampInputRangeStructure
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\HalfOpenTimestampInputRangeStructure
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get EndTimePrecision value
     * @return string|null
     */
    public function getEndTimePrecision()
    {
        return $this->EndTimePrecision;
    }
    /**
     * Set EndTimePrecision value
     * @uses \EnumType\EndTimePrecisionEnumeration::valueIsValid()
     * @uses \EnumType\EndTimePrecisionEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endTimePrecision
     * @return \StructType\HalfOpenTimestampInputRangeStructure
     */
    public function setEndTimePrecision($endTimePrecision = 'second')
    {
        // validation for constraint: enumeration
        if (!\EnumType\EndTimePrecisionEnumeration::valueIsValid($endTimePrecision)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $endTimePrecision, implode(', ', \EnumType\EndTimePrecisionEnumeration::getValidValues())), __LINE__);
        }
        $this->EndTimePrecision = $endTimePrecision;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HalfOpenTimestampInputRangeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
