<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupOfNonOrderedLocations StructType
 * @subpackage Structs
 */
class GroupOfNonOrderedLocations extends GroupOfLocations
{
    /**
     * The locationContainedInGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Location[]
     */
    public $locationContainedInGroup;
    /**
     * The groupOfNonOrderedLocationsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $groupOfNonOrderedLocationsExtension;
    /**
     * Constructor method for GroupOfNonOrderedLocations
     * @uses GroupOfNonOrderedLocations::setLocationContainedInGroup()
     * @uses GroupOfNonOrderedLocations::setGroupOfNonOrderedLocationsExtension()
     * @param \StructType\Location[] $locationContainedInGroup
     * @param \StructType\ExtensionType $groupOfNonOrderedLocationsExtension
     */
    public function __construct(array $locationContainedInGroup = array(), \StructType\ExtensionType $groupOfNonOrderedLocationsExtension = null)
    {
        $this
            ->setLocationContainedInGroup($locationContainedInGroup)
            ->setGroupOfNonOrderedLocationsExtension($groupOfNonOrderedLocationsExtension);
    }
    /**
     * Get locationContainedInGroup value
     * @return \StructType\Location[]|null
     */
    public function getLocationContainedInGroup()
    {
        return $this->locationContainedInGroup;
    }
    /**
     * Set locationContainedInGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\Location[] $locationContainedInGroup
     * @return \StructType\GroupOfNonOrderedLocations
     */
    public function setLocationContainedInGroup(array $locationContainedInGroup = array())
    {
        foreach ($locationContainedInGroup as $groupOfNonOrderedLocationsLocationContainedInGroupItem) {
            // validation for constraint: itemType
            if (!$groupOfNonOrderedLocationsLocationContainedInGroupItem instanceof \StructType\Location) {
                throw new \InvalidArgumentException(sprintf('The locationContainedInGroup property can only contain items of \StructType\Location, "%s" given', is_object($groupOfNonOrderedLocationsLocationContainedInGroupItem) ? get_class($groupOfNonOrderedLocationsLocationContainedInGroupItem) : gettype($groupOfNonOrderedLocationsLocationContainedInGroupItem)), __LINE__);
            }
        }
        $this->locationContainedInGroup = $locationContainedInGroup;
        return $this;
    }
    /**
     * Add item to locationContainedInGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\Location $item
     * @return \StructType\GroupOfNonOrderedLocations
     */
    public function addToLocationContainedInGroup(\StructType\Location $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Location) {
            throw new \InvalidArgumentException(sprintf('The locationContainedInGroup property can only contain items of \StructType\Location, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->locationContainedInGroup[] = $item;
        return $this;
    }
    /**
     * Get groupOfNonOrderedLocationsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getGroupOfNonOrderedLocationsExtension()
    {
        return $this->groupOfNonOrderedLocationsExtension;
    }
    /**
     * Set groupOfNonOrderedLocationsExtension value
     * @param \StructType\ExtensionType $groupOfNonOrderedLocationsExtension
     * @return \StructType\GroupOfNonOrderedLocations
     */
    public function setGroupOfNonOrderedLocationsExtension(\StructType\ExtensionType $groupOfNonOrderedLocationsExtension = null)
    {
        $this->groupOfNonOrderedLocationsExtension = $groupOfNonOrderedLocationsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupOfNonOrderedLocations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
