<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupOfLocationsByReference StructType
 * @subpackage Structs
 */
class GroupOfLocationsByReference extends GroupOfLocations
{
    /**
     * The predefinedLocationSetReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $predefinedLocationSetReference;
    /**
     * The groupOfLocationsByReferenceExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $groupOfLocationsByReferenceExtension;
    /**
     * Constructor method for GroupOfLocationsByReference
     * @uses GroupOfLocationsByReference::setPredefinedLocationSetReference()
     * @uses GroupOfLocationsByReference::setGroupOfLocationsByReferenceExtension()
     * @param string $predefinedLocationSetReference
     * @param \StructType\ExtensionType $groupOfLocationsByReferenceExtension
     */
    public function __construct($predefinedLocationSetReference = null, \StructType\ExtensionType $groupOfLocationsByReferenceExtension = null)
    {
        $this
            ->setPredefinedLocationSetReference($predefinedLocationSetReference)
            ->setGroupOfLocationsByReferenceExtension($groupOfLocationsByReferenceExtension);
    }
    /**
     * Get predefinedLocationSetReference value
     * @return string
     */
    public function getPredefinedLocationSetReference()
    {
        return $this->predefinedLocationSetReference;
    }
    /**
     * Set predefinedLocationSetReference value
     * @param string $predefinedLocationSetReference
     * @return \StructType\GroupOfLocationsByReference
     */
    public function setPredefinedLocationSetReference($predefinedLocationSetReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($predefinedLocationSetReference) && strlen($predefinedLocationSetReference) > 1024) || (is_array($predefinedLocationSetReference) && count($predefinedLocationSetReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($predefinedLocationSetReference) ? strlen($predefinedLocationSetReference) : count($predefinedLocationSetReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($predefinedLocationSetReference) && !is_string($predefinedLocationSetReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($predefinedLocationSetReference)), __LINE__);
        }
        $this->predefinedLocationSetReference = $predefinedLocationSetReference;
        return $this;
    }
    /**
     * Get groupOfLocationsByReferenceExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getGroupOfLocationsByReferenceExtension()
    {
        return $this->groupOfLocationsByReferenceExtension;
    }
    /**
     * Set groupOfLocationsByReferenceExtension value
     * @param \StructType\ExtensionType $groupOfLocationsByReferenceExtension
     * @return \StructType\GroupOfLocationsByReference
     */
    public function setGroupOfLocationsByReferenceExtension(\StructType\ExtensionType $groupOfLocationsByReferenceExtension = null)
    {
        $this->groupOfLocationsByReferenceExtension = $groupOfLocationsByReferenceExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupOfLocationsByReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
