<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralMessagePermissions StructType
 * Meta informations extracted from the WSDL
 * - documentation: Participant's permissions to use the service.
 * @subpackage Structs
 */
class GeneralMessagePermissions extends PermissionsStructure
{
    /**
     * The GeneralMessagePermission
     * Meta informations extracted from the WSDL
     * - documentation: Permission or a single particpant or all participants.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GeneralMessageServicePermissionStructure[]
     */
    public $GeneralMessagePermission;
    /**
     * Constructor method for GeneralMessagePermissions
     * @uses GeneralMessagePermissions::setGeneralMessagePermission()
     * @param \StructType\GeneralMessageServicePermissionStructure[] $generalMessagePermission
     */
    public function __construct(array $generalMessagePermission = array())
    {
        $this
            ->setGeneralMessagePermission($generalMessagePermission);
    }
    /**
     * Get GeneralMessagePermission value
     * @return \StructType\GeneralMessageServicePermissionStructure[]|null
     */
    public function getGeneralMessagePermission()
    {
        return $this->GeneralMessagePermission;
    }
    /**
     * Set GeneralMessagePermission value
     * @throws \InvalidArgumentException
     * @param \StructType\GeneralMessageServicePermissionStructure[] $generalMessagePermission
     * @return \StructType\GeneralMessagePermissions
     */
    public function setGeneralMessagePermission(array $generalMessagePermission = array())
    {
        foreach ($generalMessagePermission as $generalMessagePermissionsGeneralMessagePermissionItem) {
            // validation for constraint: itemType
            if (!$generalMessagePermissionsGeneralMessagePermissionItem instanceof \StructType\GeneralMessageServicePermissionStructure) {
                throw new \InvalidArgumentException(sprintf('The GeneralMessagePermission property can only contain items of \StructType\GeneralMessageServicePermissionStructure, "%s" given', is_object($generalMessagePermissionsGeneralMessagePermissionItem) ? get_class($generalMessagePermissionsGeneralMessagePermissionItem) : gettype($generalMessagePermissionsGeneralMessagePermissionItem)), __LINE__);
            }
        }
        $this->GeneralMessagePermission = $generalMessagePermission;
        return $this;
    }
    /**
     * Add item to GeneralMessagePermission value
     * @throws \InvalidArgumentException
     * @param \StructType\GeneralMessageServicePermissionStructure $item
     * @return \StructType\GeneralMessagePermissions
     */
    public function addToGeneralMessagePermission(\StructType\GeneralMessageServicePermissionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GeneralMessageServicePermissionStructure) {
            throw new \InvalidArgumentException(sprintf('The GeneralMessagePermission property can only contain items of \StructType\GeneralMessageServicePermissionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GeneralMessagePermission[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneralMessagePermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
