<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralMessageDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Delivery for General Message.
 * @subpackage Structs
 */
class GeneralMessageDeliveryStructure extends AbstractServiceDeliveryStructure
{
    /**
     * The GeneralMessage
     * @var \StructType\InfoMessageStructure
     */
    public $GeneralMessage;
    /**
     * The GeneralMessageCancellation
     * @var \StructType\InfoMessageCancellationStructure
     */
    public $GeneralMessageCancellation;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for GeneralMessageDeliveryStructure
     * @uses GeneralMessageDeliveryStructure::setGeneralMessage()
     * @uses GeneralMessageDeliveryStructure::setGeneralMessageCancellation()
     * @uses GeneralMessageDeliveryStructure::setExtensions()
     * @uses GeneralMessageDeliveryStructure::setVersion()
     * @param \StructType\InfoMessageStructure $generalMessage
     * @param \StructType\InfoMessageCancellationStructure $generalMessageCancellation
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\InfoMessageStructure $generalMessage = null, \StructType\InfoMessageCancellationStructure $generalMessageCancellation = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setGeneralMessage($generalMessage)
            ->setGeneralMessageCancellation($generalMessageCancellation)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get GeneralMessage value
     * @return \StructType\InfoMessageStructure|null
     */
    public function getGeneralMessage()
    {
        return $this->GeneralMessage;
    }
    /**
     * Set GeneralMessage value
     * @param \StructType\InfoMessageStructure $generalMessage
     * @return \StructType\GeneralMessageDeliveryStructure
     */
    public function setGeneralMessage(\StructType\InfoMessageStructure $generalMessage = null)
    {
        $this->GeneralMessage = $generalMessage;
        return $this;
    }
    /**
     * Get GeneralMessageCancellation value
     * @return \StructType\InfoMessageCancellationStructure|null
     */
    public function getGeneralMessageCancellation()
    {
        return $this->GeneralMessageCancellation;
    }
    /**
     * Set GeneralMessageCancellation value
     * @param \StructType\InfoMessageCancellationStructure $generalMessageCancellation
     * @return \StructType\GeneralMessageDeliveryStructure
     */
    public function setGeneralMessageCancellation(\StructType\InfoMessageCancellationStructure $generalMessageCancellation = null)
    {
        $this->GeneralMessageCancellation = $generalMessageCancellation;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\GeneralMessageDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\GeneralMessageDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneralMessageDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
