<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralCapabilities StructType
 * Meta informations extracted from the WSDL
 * - documentation: Permissions for general capabilities.
 * @subpackage Structs
 */
class GeneralCapabilities extends AbstractStructBase
{
    /**
     * The RequestResponse
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Participant may make direct requests for data. Default is 'true'.
     * @var bool
     */
    public $RequestResponse;
    /**
     * The PublishSubscribe
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Participant may create subscriptions. Default True.
     * @var bool
     */
    public $PublishSubscribe;
    /**
     * Constructor method for GeneralCapabilities
     * @uses GeneralCapabilities::setRequestResponse()
     * @uses GeneralCapabilities::setPublishSubscribe()
     * @param bool $requestResponse
     * @param bool $publishSubscribe
     */
    public function __construct($requestResponse = true, $publishSubscribe = true)
    {
        $this
            ->setRequestResponse($requestResponse)
            ->setPublishSubscribe($publishSubscribe);
    }
    /**
     * Get RequestResponse value
     * @return bool|null
     */
    public function getRequestResponse()
    {
        return $this->RequestResponse;
    }
    /**
     * Set RequestResponse value
     * @param bool $requestResponse
     * @return \StructType\GeneralCapabilities
     */
    public function setRequestResponse($requestResponse = true)
    {
        // validation for constraint: boolean
        if (!is_null($requestResponse) && !is_bool($requestResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requestResponse)), __LINE__);
        }
        $this->RequestResponse = $requestResponse;
        return $this;
    }
    /**
     * Get PublishSubscribe value
     * @return bool|null
     */
    public function getPublishSubscribe()
    {
        return $this->PublishSubscribe;
    }
    /**
     * Set PublishSubscribe value
     * @param bool $publishSubscribe
     * @return \StructType\GeneralCapabilities
     */
    public function setPublishSubscribe($publishSubscribe = true)
    {
        // validation for constraint: boolean
        if (!is_null($publishSubscribe) && !is_bool($publishSubscribe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($publishSubscribe)), __LINE__);
        }
        $this->PublishSubscribe = $publishSubscribe;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneralCapabilities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
