<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FromServiceJourneyInterchangeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: A planned SERVICE JOURNEY INTERCHANGE from a journey. +SIRI v2.0
 * @subpackage Structs
 */
class FromServiceJourneyInterchangeStructure extends AbstractServiceJourneyInterchangeStructure
{
    /**
     * The InterchangeCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of SERVICE JOURNEY INTERCHANGE. +SIRI v2.0 | Type for identifer of a SERVCIE JOURNEY INTERCHANGE.
     * - minOccurs: 0
     * @var string
     */
    public $InterchangeCode;
    /**
     * The ConnectionLinkRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a physical CONNECTION LINK over which the SERVICE JOURNEY INTERCHANGE takes place. +SIRI v2.0
     * - minOccurs: 0
     * @var \StructType\ConnectionLinkRefStructure
     */
    public $ConnectionLinkRef;
    /**
     * The FeederRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a feeder VEHICLE JOURNEY. +SIRI v2.0
     * @var \StructType\ConnectingJourneyRefStructure
     */
    public $FeederRef;
    /**
     * The FeederArrivalStopRef
     * Meta informations extracted from the WSDL
     * - documentation: SCHEDULED STOP POINT at which feeder journey arrives. +SIRI v2.0
     * @var \StructType\StopPointRefStructure
     */
    public $FeederArrivalStopRef;
    /**
     * The FeederVisitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Sequence of visit to Feeder stop within Feeder JOURNEY PATTERN. | Type for Stop Visit.
     * - minOccurs: 0
     * @var int
     */
    public $FeederVisitNumber;
    /**
     * The DistributorRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a feeder VEHICLE JOURNEY. +SIRI v2.0
     * - maxOccurs: 0
     * - minOccurs: 0
     * @var \StructType\ConnectingJourneyRefStructure
     */
    public $DistributorRef;
    /**
     * The DistributorDepartureStopRef
     * Meta informations extracted from the WSDL
     * - documentation: SCHEDULED STOP POINT at which distributor journet departs. +SIRI v2.0
     * - maxOccurs: 0
     * - minOccurs: 0
     * @var \StructType\StopPointRefStructure
     */
    public $DistributorDepartureStopRef;
    /**
     * The DistributorVisitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Sequence of visit to Distributor stop within Distributor JOURNEY PATTERN. | Type for Stop Visit.
     * - maxOccurs: 0
     * - minOccurs: 0
     * @var int
     */
    public $DistributorVisitNumber;
    /**
     * The StaySeated
     * @var bool
     */
    public $StaySeated;
    /**
     * The Guaranteed
     * @var bool
     */
    public $Guaranteed;
    /**
     * The Advertised
     * @var bool
     */
    public $Advertised;
    /**
     * The StandardWaitTime
     * @var string
     */
    public $StandardWaitTime;
    /**
     * The MaximumWaitTime
     * @var string
     */
    public $MaximumWaitTime;
    /**
     * The MaximumAutomaticWaitTime
     * @var string
     */
    public $MaximumAutomaticWaitTime;
    /**
     * The StandardTransferTime
     * @var string
     */
    public $StandardTransferTime;
    /**
     * The MinimumTransferTime
     * @var string
     */
    public $MinimumTransferTime;
    /**
     * The MaximumTransferTime
     * @var string
     */
    public $MaximumTransferTime;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for FromServiceJourneyInterchangeStructure
     * @uses FromServiceJourneyInterchangeStructure::setInterchangeCode()
     * @uses FromServiceJourneyInterchangeStructure::setConnectionLinkRef()
     * @uses FromServiceJourneyInterchangeStructure::setFeederRef()
     * @uses FromServiceJourneyInterchangeStructure::setFeederArrivalStopRef()
     * @uses FromServiceJourneyInterchangeStructure::setFeederVisitNumber()
     * @uses FromServiceJourneyInterchangeStructure::setDistributorRef()
     * @uses FromServiceJourneyInterchangeStructure::setDistributorDepartureStopRef()
     * @uses FromServiceJourneyInterchangeStructure::setDistributorVisitNumber()
     * @uses FromServiceJourneyInterchangeStructure::setStaySeated()
     * @uses FromServiceJourneyInterchangeStructure::setGuaranteed()
     * @uses FromServiceJourneyInterchangeStructure::setAdvertised()
     * @uses FromServiceJourneyInterchangeStructure::setStandardWaitTime()
     * @uses FromServiceJourneyInterchangeStructure::setMaximumWaitTime()
     * @uses FromServiceJourneyInterchangeStructure::setMaximumAutomaticWaitTime()
     * @uses FromServiceJourneyInterchangeStructure::setStandardTransferTime()
     * @uses FromServiceJourneyInterchangeStructure::setMinimumTransferTime()
     * @uses FromServiceJourneyInterchangeStructure::setMaximumTransferTime()
     * @uses FromServiceJourneyInterchangeStructure::setExtensions()
     * @param string $interchangeCode
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @param \StructType\ConnectingJourneyRefStructure $feederRef
     * @param \StructType\StopPointRefStructure $feederArrivalStopRef
     * @param int $feederVisitNumber
     * @param \StructType\ConnectingJourneyRefStructure $distributorRef
     * @param \StructType\StopPointRefStructure $distributorDepartureStopRef
     * @param int $distributorVisitNumber
     * @param bool $staySeated
     * @param bool $guaranteed
     * @param bool $advertised
     * @param string $standardWaitTime
     * @param string $maximumWaitTime
     * @param string $maximumAutomaticWaitTime
     * @param string $standardTransferTime
     * @param string $minimumTransferTime
     * @param string $maximumTransferTime
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($interchangeCode = null, \StructType\ConnectionLinkRefStructure $connectionLinkRef = null, \StructType\ConnectingJourneyRefStructure $feederRef = null, \StructType\StopPointRefStructure $feederArrivalStopRef = null, $feederVisitNumber = null, \StructType\ConnectingJourneyRefStructure $distributorRef = null, \StructType\StopPointRefStructure $distributorDepartureStopRef = null, $distributorVisitNumber = null, $staySeated = null, $guaranteed = null, $advertised = null, $standardWaitTime = null, $maximumWaitTime = null, $maximumAutomaticWaitTime = null, $standardTransferTime = null, $minimumTransferTime = null, $maximumTransferTime = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setInterchangeCode($interchangeCode)
            ->setConnectionLinkRef($connectionLinkRef)
            ->setFeederRef($feederRef)
            ->setFeederArrivalStopRef($feederArrivalStopRef)
            ->setFeederVisitNumber($feederVisitNumber)
            ->setDistributorRef($distributorRef)
            ->setDistributorDepartureStopRef($distributorDepartureStopRef)
            ->setDistributorVisitNumber($distributorVisitNumber)
            ->setStaySeated($staySeated)
            ->setGuaranteed($guaranteed)
            ->setAdvertised($advertised)
            ->setStandardWaitTime($standardWaitTime)
            ->setMaximumWaitTime($maximumWaitTime)
            ->setMaximumAutomaticWaitTime($maximumAutomaticWaitTime)
            ->setStandardTransferTime($standardTransferTime)
            ->setMinimumTransferTime($minimumTransferTime)
            ->setMaximumTransferTime($maximumTransferTime)
            ->setExtensions($extensions);
    }
    /**
     * Get InterchangeCode value
     * @return string|null
     */
    public function getInterchangeCode()
    {
        return $this->InterchangeCode;
    }
    /**
     * Set InterchangeCode value
     * @param string $interchangeCode
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setInterchangeCode($interchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($interchangeCode) && !is_string($interchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($interchangeCode)), __LINE__);
        }
        $this->InterchangeCode = $interchangeCode;
        return $this;
    }
    /**
     * Get ConnectionLinkRef value
     * @return \StructType\ConnectionLinkRefStructure|null
     */
    public function getConnectionLinkRef()
    {
        return $this->ConnectionLinkRef;
    }
    /**
     * Set ConnectionLinkRef value
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setConnectionLinkRef(\StructType\ConnectionLinkRefStructure $connectionLinkRef = null)
    {
        $this->ConnectionLinkRef = $connectionLinkRef;
        return $this;
    }
    /**
     * Get FeederRef value
     * @return \StructType\ConnectingJourneyRefStructure|null
     */
    public function getFeederRef()
    {
        return $this->FeederRef;
    }
    /**
     * Set FeederRef value
     * @param \StructType\ConnectingJourneyRefStructure $feederRef
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setFeederRef(\StructType\ConnectingJourneyRefStructure $feederRef = null)
    {
        $this->FeederRef = $feederRef;
        return $this;
    }
    /**
     * Get FeederArrivalStopRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getFeederArrivalStopRef()
    {
        return $this->FeederArrivalStopRef;
    }
    /**
     * Set FeederArrivalStopRef value
     * @param \StructType\StopPointRefStructure $feederArrivalStopRef
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setFeederArrivalStopRef(\StructType\StopPointRefStructure $feederArrivalStopRef = null)
    {
        $this->FeederArrivalStopRef = $feederArrivalStopRef;
        return $this;
    }
    /**
     * Get FeederVisitNumber value
     * @return int|null
     */
    public function getFeederVisitNumber()
    {
        return $this->FeederVisitNumber;
    }
    /**
     * Set FeederVisitNumber value
     * @param int $feederVisitNumber
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setFeederVisitNumber($feederVisitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($feederVisitNumber) && !is_numeric($feederVisitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($feederVisitNumber)), __LINE__);
        }
        $this->FeederVisitNumber = $feederVisitNumber;
        return $this;
    }
    /**
     * Get DistributorRef value
     * @return \StructType\ConnectingJourneyRefStructure|null
     */
    public function getDistributorRef()
    {
        return $this->DistributorRef;
    }
    /**
     * Set DistributorRef value
     * @param \StructType\ConnectingJourneyRefStructure $distributorRef
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setDistributorRef(\StructType\ConnectingJourneyRefStructure $distributorRef = null)
    {
        $this->DistributorRef = $distributorRef;
        return $this;
    }
    /**
     * Get DistributorDepartureStopRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getDistributorDepartureStopRef()
    {
        return $this->DistributorDepartureStopRef;
    }
    /**
     * Set DistributorDepartureStopRef value
     * @param \StructType\StopPointRefStructure $distributorDepartureStopRef
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setDistributorDepartureStopRef(\StructType\StopPointRefStructure $distributorDepartureStopRef = null)
    {
        $this->DistributorDepartureStopRef = $distributorDepartureStopRef;
        return $this;
    }
    /**
     * Get DistributorVisitNumber value
     * @return int|null
     */
    public function getDistributorVisitNumber()
    {
        return $this->DistributorVisitNumber;
    }
    /**
     * Set DistributorVisitNumber value
     * @param int $distributorVisitNumber
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setDistributorVisitNumber($distributorVisitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($distributorVisitNumber) && !is_numeric($distributorVisitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributorVisitNumber)), __LINE__);
        }
        $this->DistributorVisitNumber = $distributorVisitNumber;
        return $this;
    }
    /**
     * Get StaySeated value
     * @return bool|null
     */
    public function getStaySeated()
    {
        return $this->StaySeated;
    }
    /**
     * Set StaySeated value
     * @param bool $staySeated
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setStaySeated($staySeated = null)
    {
        // validation for constraint: boolean
        if (!is_null($staySeated) && !is_bool($staySeated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($staySeated)), __LINE__);
        }
        $this->StaySeated = $staySeated;
        return $this;
    }
    /**
     * Get Guaranteed value
     * @return bool|null
     */
    public function getGuaranteed()
    {
        return $this->Guaranteed;
    }
    /**
     * Set Guaranteed value
     * @param bool $guaranteed
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setGuaranteed($guaranteed = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteed) && !is_bool($guaranteed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($guaranteed)), __LINE__);
        }
        $this->Guaranteed = $guaranteed;
        return $this;
    }
    /**
     * Get Advertised value
     * @return bool|null
     */
    public function getAdvertised()
    {
        return $this->Advertised;
    }
    /**
     * Set Advertised value
     * @param bool $advertised
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setAdvertised($advertised = null)
    {
        // validation for constraint: boolean
        if (!is_null($advertised) && !is_bool($advertised)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($advertised)), __LINE__);
        }
        $this->Advertised = $advertised;
        return $this;
    }
    /**
     * Get StandardWaitTime value
     * @return string|null
     */
    public function getStandardWaitTime()
    {
        return $this->StandardWaitTime;
    }
    /**
     * Set StandardWaitTime value
     * @param string $standardWaitTime
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setStandardWaitTime($standardWaitTime = null)
    {
        // validation for constraint: string
        if (!is_null($standardWaitTime) && !is_string($standardWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($standardWaitTime)), __LINE__);
        }
        $this->StandardWaitTime = $standardWaitTime;
        return $this;
    }
    /**
     * Get MaximumWaitTime value
     * @return string|null
     */
    public function getMaximumWaitTime()
    {
        return $this->MaximumWaitTime;
    }
    /**
     * Set MaximumWaitTime value
     * @param string $maximumWaitTime
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setMaximumWaitTime($maximumWaitTime = null)
    {
        // validation for constraint: string
        if (!is_null($maximumWaitTime) && !is_string($maximumWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumWaitTime)), __LINE__);
        }
        $this->MaximumWaitTime = $maximumWaitTime;
        return $this;
    }
    /**
     * Get MaximumAutomaticWaitTime value
     * @return string|null
     */
    public function getMaximumAutomaticWaitTime()
    {
        return $this->MaximumAutomaticWaitTime;
    }
    /**
     * Set MaximumAutomaticWaitTime value
     * @param string $maximumAutomaticWaitTime
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setMaximumAutomaticWaitTime($maximumAutomaticWaitTime = null)
    {
        // validation for constraint: string
        if (!is_null($maximumAutomaticWaitTime) && !is_string($maximumAutomaticWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumAutomaticWaitTime)), __LINE__);
        }
        $this->MaximumAutomaticWaitTime = $maximumAutomaticWaitTime;
        return $this;
    }
    /**
     * Get StandardTransferTime value
     * @return string|null
     */
    public function getStandardTransferTime()
    {
        return $this->StandardTransferTime;
    }
    /**
     * Set StandardTransferTime value
     * @param string $standardTransferTime
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setStandardTransferTime($standardTransferTime = null)
    {
        // validation for constraint: string
        if (!is_null($standardTransferTime) && !is_string($standardTransferTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($standardTransferTime)), __LINE__);
        }
        $this->StandardTransferTime = $standardTransferTime;
        return $this;
    }
    /**
     * Get MinimumTransferTime value
     * @return string|null
     */
    public function getMinimumTransferTime()
    {
        return $this->MinimumTransferTime;
    }
    /**
     * Set MinimumTransferTime value
     * @param string $minimumTransferTime
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setMinimumTransferTime($minimumTransferTime = null)
    {
        // validation for constraint: string
        if (!is_null($minimumTransferTime) && !is_string($minimumTransferTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minimumTransferTime)), __LINE__);
        }
        $this->MinimumTransferTime = $minimumTransferTime;
        return $this;
    }
    /**
     * Get MaximumTransferTime value
     * @return string|null
     */
    public function getMaximumTransferTime()
    {
        return $this->MaximumTransferTime;
    }
    /**
     * Set MaximumTransferTime value
     * @param string $maximumTransferTime
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setMaximumTransferTime($maximumTransferTime = null)
    {
        // validation for constraint: string
        if (!is_null($maximumTransferTime) && !is_string($maximumTransferTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumTransferTime)), __LINE__);
        }
        $this->MaximumTransferTime = $maximumTransferTime;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FromServiceJourneyInterchangeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
