<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FramedVehicleJourneyRefStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for identifer of a VEHICLE JOURNEY within data Horizon of a service.
 * @subpackage Structs
 */
class FramedVehicleJourneyRefStructure extends AbstractStructBase
{
    /**
     * The DataFrameRef
     * Meta informations extracted from the WSDL
     * - documentation: identifier of data frame within particpant service. Used to ensure that the Reference to a DATED VEGICLE JOURNEY is unique with the data horizon of the service. Often the OperationalDayType is used for this purpose.
     * @var \StructType\DataFrameRefStructure
     */
    public $DataFrameRef;
    /**
     * The DatedVehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: A reference to the dated VEHICLE JOURNEY that the VEHICLE is making. | Type for identifier of a Dated VEHICLE JOURNEY.
     * @var string
     */
    public $DatedVehicleJourneyRef;
    /**
     * Constructor method for FramedVehicleJourneyRefStructure
     * @uses FramedVehicleJourneyRefStructure::setDataFrameRef()
     * @uses FramedVehicleJourneyRefStructure::setDatedVehicleJourneyRef()
     * @param \StructType\DataFrameRefStructure $dataFrameRef
     * @param string $datedVehicleJourneyRef
     */
    public function __construct(\StructType\DataFrameRefStructure $dataFrameRef = null, $datedVehicleJourneyRef = null)
    {
        $this
            ->setDataFrameRef($dataFrameRef)
            ->setDatedVehicleJourneyRef($datedVehicleJourneyRef);
    }
    /**
     * Get DataFrameRef value
     * @return \StructType\DataFrameRefStructure|null
     */
    public function getDataFrameRef()
    {
        return $this->DataFrameRef;
    }
    /**
     * Set DataFrameRef value
     * @param \StructType\DataFrameRefStructure $dataFrameRef
     * @return \StructType\FramedVehicleJourneyRefStructure
     */
    public function setDataFrameRef(\StructType\DataFrameRefStructure $dataFrameRef = null)
    {
        $this->DataFrameRef = $dataFrameRef;
        return $this;
    }
    /**
     * Get DatedVehicleJourneyRef value
     * @return string|null
     */
    public function getDatedVehicleJourneyRef()
    {
        return $this->DatedVehicleJourneyRef;
    }
    /**
     * Set DatedVehicleJourneyRef value
     * @param string $datedVehicleJourneyRef
     * @return \StructType\FramedVehicleJourneyRefStructure
     */
    public function setDatedVehicleJourneyRef($datedVehicleJourneyRef = null)
    {
        // validation for constraint: string
        if (!is_null($datedVehicleJourneyRef) && !is_string($datedVehicleJourneyRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datedVehicleJourneyRef)), __LINE__);
        }
        $this->DatedVehicleJourneyRef = $datedVehicleJourneyRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FramedVehicleJourneyRefStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
