<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeatureRefs StructType
 * Meta informations extracted from the WSDL
 * - documentation: Classification of features.
 * - minOccurs: 0
 * @subpackage Structs
 */
class FeatureRefs extends AbstractStructBase
{
    /**
     * The FeatureRef
     * Meta informations extracted from the WSDL
     * - documentation: Features of LOCAL SERVICe.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceFeatureRefStructure[]
     */
    public $FeatureRef;
    /**
     * Constructor method for FeatureRefs
     * @uses FeatureRefs::setFeatureRef()
     * @param \StructType\ServiceFeatureRefStructure[] $featureRef
     */
    public function __construct(array $featureRef = array())
    {
        $this
            ->setFeatureRef($featureRef);
    }
    /**
     * Get FeatureRef value
     * @return \StructType\ServiceFeatureRefStructure[]|null
     */
    public function getFeatureRef()
    {
        return $this->FeatureRef;
    }
    /**
     * Set FeatureRef value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureRefStructure[] $featureRef
     * @return \StructType\FeatureRefs
     */
    public function setFeatureRef(array $featureRef = array())
    {
        foreach ($featureRef as $featureRefsFeatureRefItem) {
            // validation for constraint: itemType
            if (!$featureRefsFeatureRefItem instanceof \StructType\ServiceFeatureRefStructure) {
                throw new \InvalidArgumentException(sprintf('The FeatureRef property can only contain items of \StructType\ServiceFeatureRefStructure, "%s" given', is_object($featureRefsFeatureRefItem) ? get_class($featureRefsFeatureRefItem) : gettype($featureRefsFeatureRefItem)), __LINE__);
            }
        }
        $this->FeatureRef = $featureRef;
        return $this;
    }
    /**
     * Add item to FeatureRef value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureRefStructure $item
     * @return \StructType\FeatureRefs
     */
    public function addToFeatureRef(\StructType\ServiceFeatureRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureRefStructure) {
            throw new \InvalidArgumentException(sprintf('The FeatureRef property can only contain items of \StructType\ServiceFeatureRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FeatureRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeatureRefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
