<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeatureRefStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for reference to a Feature Code. | Type for reference to a FEATURE. | Type for identifier of a StopFeature. SIRI provides a recommended set of values covering most usages, intended to be TPEG comnpatible. See the SIRI facilities
 * packaged.
 * @subpackage Structs
 */
class FeatureRefStructure extends AbstractStructBase
{
    /**
     * The FeatureIdRef
     * Meta informations extracted from the WSDL
     * - documentation: Unique identfiier of referenced element, eg TOId.
     * @var \StructType\FeatureIdRefStructure
     */
    public $FeatureIdRef;
    /**
     * The FeatureType
     * Meta informations extracted from the WSDL
     * - documentation: Type for identifier of FEATURE.
     * - minOccurs: 0
     * @var string
     */
    public $FeatureType;
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - documentation: Type for identifier of a StopFeature. SIRI provides a recommended set of values covering most usages, intended to be TPEG comnpatible. See the SIRI facilities packaged.
     * @var string
     */
    public $_;
    /**
     * Constructor method for FeatureRefStructure
     * @uses FeatureRefStructure::setFeatureIdRef()
     * @uses FeatureRefStructure::setFeatureType()
     * @uses FeatureRefStructure::set_()
     * @param \StructType\FeatureIdRefStructure $featureIdRef
     * @param string $featureType
     * @param string $_
     */
    public function __construct(\StructType\FeatureIdRefStructure $featureIdRef = null, $featureType = null, $_ = null)
    {
        $this
            ->setFeatureIdRef($featureIdRef)
            ->setFeatureType($featureType)
            ->set_($_);
    }
    /**
     * Get FeatureIdRef value
     * @return \StructType\FeatureIdRefStructure|null
     */
    public function getFeatureIdRef()
    {
        return $this->FeatureIdRef;
    }
    /**
     * Set FeatureIdRef value
     * @param \StructType\FeatureIdRefStructure $featureIdRef
     * @return \StructType\FeatureRefStructure
     */
    public function setFeatureIdRef(\StructType\FeatureIdRefStructure $featureIdRef = null)
    {
        $this->FeatureIdRef = $featureIdRef;
        return $this;
    }
    /**
     * Get FeatureType value
     * @return string|null
     */
    public function getFeatureType()
    {
        return $this->FeatureType;
    }
    /**
     * Set FeatureType value
     * @param string $featureType
     * @return \StructType\FeatureRefStructure
     */
    public function setFeatureType($featureType = null)
    {
        // validation for constraint: string
        if (!is_null($featureType) && !is_string($featureType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($featureType)), __LINE__);
        }
        $this->FeatureType = $featureType;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\FeatureRefStructure
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeatureRefStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
