<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityMonitoringRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Functional Service Request for Facility Monitoring Service.
 * @subpackage Structs
 */
class FacilityMonitoringRequestStructure extends AbstractFunctionalServiceRequestStructure
{
    /**
     * The PreviewInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $PreviewInterval;
    /**
     * The StartTime
     * @var string
     */
    public $StartTime;
    /**
     * The FacilityRef
     * @var \StructType\FacilityRefStructure
     */
    public $FacilityRef;
    /**
     * The FeatureRef
     * @var \StructType\FeatureRefStructure
     */
    public $FeatureRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The ConnectionLinkRef
     * @var \StructType\ConnectionLinkRefStructure
     */
    public $ConnectionLinkRef;
    /**
     * The FramedVehicleJourneyRef
     * @var \StructType\FramedVehicleJourneyRefStructure
     */
    public $FramedVehicleJourneyRef;
    /**
     * The VehicleJourneyRef
     * @var \StructType\VehicleJourneyRefStructure
     */
    public $VehicleJourneyRef;
    /**
     * The InterchangeRef
     * @var \StructType\InterchangeRefStructure
     */
    public $InterchangeRef;
    /**
     * The VehicleRef
     * @var \StructType\VehicleRefStructure
     */
    public $VehicleRef;
    /**
     * The StopPlaceRef
     * @var \StructType\StopPlaceRefStructure
     */
    public $StopPlaceRef;
    /**
     * The StopPlaceComponentRef
     * @var \StructType\StopPlaceComponentRefStructure
     */
    public $StopPlaceComponentRef;
    /**
     * The AccessibilityNeedsFilter
     * @var \StructType\AccessibilityNeedsFilterStructure
     */
    public $AccessibilityNeedsFilter;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The IncludeTranslations
     * @var bool
     */
    public $IncludeTranslations;
    /**
     * The MaximumNumberOfFacilityConditions
     * @var int
     */
    public $MaximumNumberOfFacilityConditions;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for FacilityMonitoringRequestStructure
     * @uses FacilityMonitoringRequestStructure::setPreviewInterval()
     * @uses FacilityMonitoringRequestStructure::setStartTime()
     * @uses FacilityMonitoringRequestStructure::setFacilityRef()
     * @uses FacilityMonitoringRequestStructure::setFeatureRef()
     * @uses FacilityMonitoringRequestStructure::setLineRef()
     * @uses FacilityMonitoringRequestStructure::setStopPointRef()
     * @uses FacilityMonitoringRequestStructure::setConnectionLinkRef()
     * @uses FacilityMonitoringRequestStructure::setFramedVehicleJourneyRef()
     * @uses FacilityMonitoringRequestStructure::setVehicleJourneyRef()
     * @uses FacilityMonitoringRequestStructure::setInterchangeRef()
     * @uses FacilityMonitoringRequestStructure::setVehicleRef()
     * @uses FacilityMonitoringRequestStructure::setStopPlaceRef()
     * @uses FacilityMonitoringRequestStructure::setStopPlaceComponentRef()
     * @uses FacilityMonitoringRequestStructure::setAccessibilityNeedsFilter()
     * @uses FacilityMonitoringRequestStructure::setLanguage()
     * @uses FacilityMonitoringRequestStructure::setIncludeTranslations()
     * @uses FacilityMonitoringRequestStructure::setMaximumNumberOfFacilityConditions()
     * @uses FacilityMonitoringRequestStructure::setExtensions()
     * @uses FacilityMonitoringRequestStructure::setVersion()
     * @param string $previewInterval
     * @param string $startTime
     * @param \StructType\FacilityRefStructure $facilityRef
     * @param \StructType\FeatureRefStructure $featureRef
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @param \StructType\VehicleJourneyRefStructure $vehicleJourneyRef
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @param \StructType\StopPlaceRefStructure $stopPlaceRef
     * @param \StructType\StopPlaceComponentRefStructure $stopPlaceComponentRef
     * @param \StructType\AccessibilityNeedsFilterStructure $accessibilityNeedsFilter
     * @param string $language
     * @param bool $includeTranslations
     * @param int $maximumNumberOfFacilityConditions
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct($previewInterval = null, $startTime = null, \StructType\FacilityRefStructure $facilityRef = null, \StructType\FeatureRefStructure $featureRef = null, \StructType\LineRefStructure $lineRef = null, \StructType\StopPointRefStructure $stopPointRef = null, \StructType\ConnectionLinkRefStructure $connectionLinkRef = null, \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null, \StructType\VehicleJourneyRefStructure $vehicleJourneyRef = null, \StructType\InterchangeRefStructure $interchangeRef = null, \StructType\VehicleRefStructure $vehicleRef = null, \StructType\StopPlaceRefStructure $stopPlaceRef = null, \StructType\StopPlaceComponentRefStructure $stopPlaceComponentRef = null, \StructType\AccessibilityNeedsFilterStructure $accessibilityNeedsFilter = null, $language = null, $includeTranslations = null, $maximumNumberOfFacilityConditions = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setPreviewInterval($previewInterval)
            ->setStartTime($startTime)
            ->setFacilityRef($facilityRef)
            ->setFeatureRef($featureRef)
            ->setLineRef($lineRef)
            ->setStopPointRef($stopPointRef)
            ->setConnectionLinkRef($connectionLinkRef)
            ->setFramedVehicleJourneyRef($framedVehicleJourneyRef)
            ->setVehicleJourneyRef($vehicleJourneyRef)
            ->setInterchangeRef($interchangeRef)
            ->setVehicleRef($vehicleRef)
            ->setStopPlaceRef($stopPlaceRef)
            ->setStopPlaceComponentRef($stopPlaceComponentRef)
            ->setAccessibilityNeedsFilter($accessibilityNeedsFilter)
            ->setLanguage($language)
            ->setIncludeTranslations($includeTranslations)
            ->setMaximumNumberOfFacilityConditions($maximumNumberOfFacilityConditions)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get PreviewInterval value
     * @return string|null
     */
    public function getPreviewInterval()
    {
        return $this->PreviewInterval;
    }
    /**
     * Set PreviewInterval value
     * @param string $previewInterval
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setPreviewInterval($previewInterval = null)
    {
        // validation for constraint: string
        if (!is_null($previewInterval) && !is_string($previewInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previewInterval)), __LINE__);
        }
        $this->PreviewInterval = $previewInterval;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get FacilityRef value
     * @return \StructType\FacilityRefStructure|null
     */
    public function getFacilityRef()
    {
        return $this->FacilityRef;
    }
    /**
     * Set FacilityRef value
     * @param \StructType\FacilityRefStructure $facilityRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setFacilityRef(\StructType\FacilityRefStructure $facilityRef = null)
    {
        $this->FacilityRef = $facilityRef;
        return $this;
    }
    /**
     * Get FeatureRef value
     * @return \StructType\FeatureRefStructure|null
     */
    public function getFeatureRef()
    {
        return $this->FeatureRef;
    }
    /**
     * Set FeatureRef value
     * @param \StructType\FeatureRefStructure $featureRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setFeatureRef(\StructType\FeatureRefStructure $featureRef = null)
    {
        $this->FeatureRef = $featureRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get ConnectionLinkRef value
     * @return \StructType\ConnectionLinkRefStructure|null
     */
    public function getConnectionLinkRef()
    {
        return $this->ConnectionLinkRef;
    }
    /**
     * Set ConnectionLinkRef value
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setConnectionLinkRef(\StructType\ConnectionLinkRefStructure $connectionLinkRef = null)
    {
        $this->ConnectionLinkRef = $connectionLinkRef;
        return $this;
    }
    /**
     * Get FramedVehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure|null
     */
    public function getFramedVehicleJourneyRef()
    {
        return $this->FramedVehicleJourneyRef;
    }
    /**
     * Set FramedVehicleJourneyRef value
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setFramedVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null)
    {
        $this->FramedVehicleJourneyRef = $framedVehicleJourneyRef;
        return $this;
    }
    /**
     * Get VehicleJourneyRef value
     * @return \StructType\VehicleJourneyRefStructure|null
     */
    public function getVehicleJourneyRef()
    {
        return $this->VehicleJourneyRef;
    }
    /**
     * Set VehicleJourneyRef value
     * @param \StructType\VehicleJourneyRefStructure $vehicleJourneyRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setVehicleJourneyRef(\StructType\VehicleJourneyRefStructure $vehicleJourneyRef = null)
    {
        $this->VehicleJourneyRef = $vehicleJourneyRef;
        return $this;
    }
    /**
     * Get InterchangeRef value
     * @return \StructType\InterchangeRefStructure|null
     */
    public function getInterchangeRef()
    {
        return $this->InterchangeRef;
    }
    /**
     * Set InterchangeRef value
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setInterchangeRef(\StructType\InterchangeRefStructure $interchangeRef = null)
    {
        $this->InterchangeRef = $interchangeRef;
        return $this;
    }
    /**
     * Get VehicleRef value
     * @return \StructType\VehicleRefStructure|null
     */
    public function getVehicleRef()
    {
        return $this->VehicleRef;
    }
    /**
     * Set VehicleRef value
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setVehicleRef(\StructType\VehicleRefStructure $vehicleRef = null)
    {
        $this->VehicleRef = $vehicleRef;
        return $this;
    }
    /**
     * Get StopPlaceRef value
     * @return \StructType\StopPlaceRefStructure|null
     */
    public function getStopPlaceRef()
    {
        return $this->StopPlaceRef;
    }
    /**
     * Set StopPlaceRef value
     * @param \StructType\StopPlaceRefStructure $stopPlaceRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setStopPlaceRef(\StructType\StopPlaceRefStructure $stopPlaceRef = null)
    {
        $this->StopPlaceRef = $stopPlaceRef;
        return $this;
    }
    /**
     * Get StopPlaceComponentRef value
     * @return \StructType\StopPlaceComponentRefStructure|null
     */
    public function getStopPlaceComponentRef()
    {
        return $this->StopPlaceComponentRef;
    }
    /**
     * Set StopPlaceComponentRef value
     * @param \StructType\StopPlaceComponentRefStructure $stopPlaceComponentRef
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setStopPlaceComponentRef(\StructType\StopPlaceComponentRefStructure $stopPlaceComponentRef = null)
    {
        $this->StopPlaceComponentRef = $stopPlaceComponentRef;
        return $this;
    }
    /**
     * Get AccessibilityNeedsFilter value
     * @return \StructType\AccessibilityNeedsFilterStructure|null
     */
    public function getAccessibilityNeedsFilter()
    {
        return $this->AccessibilityNeedsFilter;
    }
    /**
     * Set AccessibilityNeedsFilter value
     * @param \StructType\AccessibilityNeedsFilterStructure $accessibilityNeedsFilter
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setAccessibilityNeedsFilter(\StructType\AccessibilityNeedsFilterStructure $accessibilityNeedsFilter = null)
    {
        $this->AccessibilityNeedsFilter = $accessibilityNeedsFilter;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get IncludeTranslations value
     * @return bool|null
     */
    public function getIncludeTranslations()
    {
        return $this->IncludeTranslations;
    }
    /**
     * Set IncludeTranslations value
     * @param bool $includeTranslations
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setIncludeTranslations($includeTranslations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTranslations) && !is_bool($includeTranslations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTranslations)), __LINE__);
        }
        $this->IncludeTranslations = $includeTranslations;
        return $this;
    }
    /**
     * Get MaximumNumberOfFacilityConditions value
     * @return int|null
     */
    public function getMaximumNumberOfFacilityConditions()
    {
        return $this->MaximumNumberOfFacilityConditions;
    }
    /**
     * Set MaximumNumberOfFacilityConditions value
     * @param int $maximumNumberOfFacilityConditions
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setMaximumNumberOfFacilityConditions($maximumNumberOfFacilityConditions = null)
    {
        // validation for constraint: int
        if (!is_null($maximumNumberOfFacilityConditions) && !is_numeric($maximumNumberOfFacilityConditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumNumberOfFacilityConditions)), __LINE__);
        }
        $this->MaximumNumberOfFacilityConditions = $maximumNumberOfFacilityConditions;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityMonitoringRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
