<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Response with Facilities available to make requests.
 * @subpackage Structs
 */
class FacilityDeliveryStructure extends AbstractDiscoveryDeliveryStructure
{
    /**
     * The AnnotatedFacility
     * Meta informations extracted from the WSDL
     * - documentation: Facility Definition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AnnotatedFacilityStructure[]
     */
    public $AnnotatedFacility;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed. | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for FacilityDeliveryStructure
     * @uses FacilityDeliveryStructure::setAnnotatedFacility()
     * @uses FacilityDeliveryStructure::setExtensions()
     * @uses FacilityDeliveryStructure::setVersion()
     * @param \StructType\AnnotatedFacilityStructure[] $annotatedFacility
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(array $annotatedFacility = array(), \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setAnnotatedFacility($annotatedFacility)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get AnnotatedFacility value
     * @return \StructType\AnnotatedFacilityStructure[]|null
     */
    public function getAnnotatedFacility()
    {
        return $this->AnnotatedFacility;
    }
    /**
     * Set AnnotatedFacility value
     * @throws \InvalidArgumentException
     * @param \StructType\AnnotatedFacilityStructure[] $annotatedFacility
     * @return \StructType\FacilityDeliveryStructure
     */
    public function setAnnotatedFacility(array $annotatedFacility = array())
    {
        foreach ($annotatedFacility as $facilityDeliveryStructureAnnotatedFacilityItem) {
            // validation for constraint: itemType
            if (!$facilityDeliveryStructureAnnotatedFacilityItem instanceof \StructType\AnnotatedFacilityStructure) {
                throw new \InvalidArgumentException(sprintf('The AnnotatedFacility property can only contain items of \StructType\AnnotatedFacilityStructure, "%s" given', is_object($facilityDeliveryStructureAnnotatedFacilityItem) ? get_class($facilityDeliveryStructureAnnotatedFacilityItem) : gettype($facilityDeliveryStructureAnnotatedFacilityItem)), __LINE__);
            }
        }
        $this->AnnotatedFacility = $annotatedFacility;
        return $this;
    }
    /**
     * Add item to AnnotatedFacility value
     * @throws \InvalidArgumentException
     * @param \StructType\AnnotatedFacilityStructure $item
     * @return \StructType\FacilityDeliveryStructure
     */
    public function addToAnnotatedFacility(\StructType\AnnotatedFacilityStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnnotatedFacilityStructure) {
            throw new \InvalidArgumentException(sprintf('The AnnotatedFacility property can only contain items of \StructType\AnnotatedFacilityStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AnnotatedFacility[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\FacilityDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\FacilityDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
