<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedVersionFrameStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for version frame structure. | Connection parameters for a monitored SERVICE JOURNEY INTERCHANGE between a feeder and distributor journey. SIRI 2.0
 * @subpackage Structs
 */
class EstimatedVersionFrameStructure extends AbstractItemStructure
{
    /**
     * The VersionRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: VersionRef
     * - documentation: Type for identifier of a Version.
     * @var string
     */
    public $VersionRef;
    /**
     * The EstimatedVehicleJourney
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: EstimatedVehicleJourney
     * @var \StructType\EstimatedVehicleJourneyStructure[]
     */
    public $EstimatedVehicleJourney;
    /**
     * The EstimatedServiceJourneyInterchange
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: EstimatedServiceJourneyInterchange
     * @var \StructType\EstimatedServiceJourneyInterchangeStructure[]
     */
    public $EstimatedServiceJourneyInterchange;
    /**
     * Constructor method for EstimatedVersionFrameStructure
     * @uses EstimatedVersionFrameStructure::setVersionRef()
     * @uses EstimatedVersionFrameStructure::setEstimatedVehicleJourney()
     * @uses EstimatedVersionFrameStructure::setEstimatedServiceJourneyInterchange()
     * @param string $versionRef
     * @param \StructType\EstimatedVehicleJourneyStructure[] $estimatedVehicleJourney
     * @param \StructType\EstimatedServiceJourneyInterchangeStructure[] $estimatedServiceJourneyInterchange
     */
    public function __construct($versionRef = null, array $estimatedVehicleJourney = array(), array $estimatedServiceJourneyInterchange = array())
    {
        $this
            ->setVersionRef($versionRef)
            ->setEstimatedVehicleJourney($estimatedVehicleJourney)
            ->setEstimatedServiceJourneyInterchange($estimatedServiceJourneyInterchange);
    }
    /**
     * Get VersionRef value
     * @return string|null
     */
    public function getVersionRef()
    {
        return $this->VersionRef;
    }
    /**
     * Set VersionRef value
     * @param string $versionRef
     * @return \StructType\EstimatedVersionFrameStructure
     */
    public function setVersionRef($versionRef = null)
    {
        // validation for constraint: string
        if (!is_null($versionRef) && !is_string($versionRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionRef)), __LINE__);
        }
        $this->VersionRef = $versionRef;
        return $this;
    }
    /**
     * Get EstimatedVehicleJourney value
     * @return \StructType\EstimatedVehicleJourneyStructure[]|null
     */
    public function getEstimatedVehicleJourney()
    {
        return $this->EstimatedVehicleJourney;
    }
    /**
     * Set EstimatedVehicleJourney value
     * @throws \InvalidArgumentException
     * @param \StructType\EstimatedVehicleJourneyStructure[] $estimatedVehicleJourney
     * @return \StructType\EstimatedVersionFrameStructure
     */
    public function setEstimatedVehicleJourney(array $estimatedVehicleJourney = array())
    {
        foreach ($estimatedVehicleJourney as $estimatedVersionFrameStructureEstimatedVehicleJourneyItem) {
            // validation for constraint: itemType
            if (!$estimatedVersionFrameStructureEstimatedVehicleJourneyItem instanceof \StructType\EstimatedVehicleJourneyStructure) {
                throw new \InvalidArgumentException(sprintf('The EstimatedVehicleJourney property can only contain items of \StructType\EstimatedVehicleJourneyStructure, "%s" given', is_object($estimatedVersionFrameStructureEstimatedVehicleJourneyItem) ? get_class($estimatedVersionFrameStructureEstimatedVehicleJourneyItem) : gettype($estimatedVersionFrameStructureEstimatedVehicleJourneyItem)), __LINE__);
            }
        }
        $this->EstimatedVehicleJourney = $estimatedVehicleJourney;
        return $this;
    }
    /**
     * Add item to EstimatedVehicleJourney value
     * @throws \InvalidArgumentException
     * @param \StructType\EstimatedVehicleJourneyStructure $item
     * @return \StructType\EstimatedVersionFrameStructure
     */
    public function addToEstimatedVehicleJourney(\StructType\EstimatedVehicleJourneyStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EstimatedVehicleJourneyStructure) {
            throw new \InvalidArgumentException(sprintf('The EstimatedVehicleJourney property can only contain items of \StructType\EstimatedVehicleJourneyStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EstimatedVehicleJourney[] = $item;
        return $this;
    }
    /**
     * Get EstimatedServiceJourneyInterchange value
     * @return \StructType\EstimatedServiceJourneyInterchangeStructure[]|null
     */
    public function getEstimatedServiceJourneyInterchange()
    {
        return $this->EstimatedServiceJourneyInterchange;
    }
    /**
     * Set EstimatedServiceJourneyInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\EstimatedServiceJourneyInterchangeStructure[] $estimatedServiceJourneyInterchange
     * @return \StructType\EstimatedVersionFrameStructure
     */
    public function setEstimatedServiceJourneyInterchange(array $estimatedServiceJourneyInterchange = array())
    {
        foreach ($estimatedServiceJourneyInterchange as $estimatedVersionFrameStructureEstimatedServiceJourneyInterchangeItem) {
            // validation for constraint: itemType
            if (!$estimatedVersionFrameStructureEstimatedServiceJourneyInterchangeItem instanceof \StructType\EstimatedServiceJourneyInterchangeStructure) {
                throw new \InvalidArgumentException(sprintf('The EstimatedServiceJourneyInterchange property can only contain items of \StructType\EstimatedServiceJourneyInterchangeStructure, "%s" given', is_object($estimatedVersionFrameStructureEstimatedServiceJourneyInterchangeItem) ? get_class($estimatedVersionFrameStructureEstimatedServiceJourneyInterchangeItem) : gettype($estimatedVersionFrameStructureEstimatedServiceJourneyInterchangeItem)), __LINE__);
            }
        }
        $this->EstimatedServiceJourneyInterchange = $estimatedServiceJourneyInterchange;
        return $this;
    }
    /**
     * Add item to EstimatedServiceJourneyInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\EstimatedServiceJourneyInterchangeStructure $item
     * @return \StructType\EstimatedVersionFrameStructure
     */
    public function addToEstimatedServiceJourneyInterchange(\StructType\EstimatedServiceJourneyInterchangeStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EstimatedServiceJourneyInterchangeStructure) {
            throw new \InvalidArgumentException(sprintf('The EstimatedServiceJourneyInterchange property can only contain items of \StructType\EstimatedServiceJourneyInterchangeStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EstimatedServiceJourneyInterchange[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstimatedVersionFrameStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
