<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedTimetableRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Type for Functional Service Request for Estimated Timetable.
 * @subpackage Structs
 */
class EstimatedTimetableRequestStructure extends AbstractFunctionalServiceRequestStructure
{
    /**
     * The PreviewInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $PreviewInterval;
    /**
     * The TimetableVersionRef
     * @var \StructType\VersionRefStructure
     */
    public $TimetableVersionRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The Lines
     * @var \StructType\Lines
     */
    public $Lines;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The IncludeTranslations
     * @var bool
     */
    public $IncludeTranslations;
    /**
     * The EstimatedTimetableDetailLevel
     * @var string
     */
    public $EstimatedTimetableDetailLevel;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for EstimatedTimetableRequestStructure
     * @uses EstimatedTimetableRequestStructure::setPreviewInterval()
     * @uses EstimatedTimetableRequestStructure::setTimetableVersionRef()
     * @uses EstimatedTimetableRequestStructure::setOperatorRef()
     * @uses EstimatedTimetableRequestStructure::setLines()
     * @uses EstimatedTimetableRequestStructure::setLanguage()
     * @uses EstimatedTimetableRequestStructure::setIncludeTranslations()
     * @uses EstimatedTimetableRequestStructure::setEstimatedTimetableDetailLevel()
     * @uses EstimatedTimetableRequestStructure::setExtensions()
     * @uses EstimatedTimetableRequestStructure::setVersion()
     * @param string $previewInterval
     * @param \StructType\VersionRefStructure $timetableVersionRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\Lines $lines
     * @param string $language
     * @param bool $includeTranslations
     * @param string $estimatedTimetableDetailLevel
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct($previewInterval = null, \StructType\VersionRefStructure $timetableVersionRef = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\Lines $lines = null, $language = null, $includeTranslations = null, $estimatedTimetableDetailLevel = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setPreviewInterval($previewInterval)
            ->setTimetableVersionRef($timetableVersionRef)
            ->setOperatorRef($operatorRef)
            ->setLines($lines)
            ->setLanguage($language)
            ->setIncludeTranslations($includeTranslations)
            ->setEstimatedTimetableDetailLevel($estimatedTimetableDetailLevel)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get PreviewInterval value
     * @return string|null
     */
    public function getPreviewInterval()
    {
        return $this->PreviewInterval;
    }
    /**
     * Set PreviewInterval value
     * @param string $previewInterval
     * @return \StructType\EstimatedTimetableRequestStructure
     */
    public function setPreviewInterval($previewInterval = null)
    {
        // validation for constraint: string
        if (!is_null($previewInterval) && !is_string($previewInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previewInterval)), __LINE__);
        }
        $this->PreviewInterval = $previewInterval;
        return $this;
    }
    /**
     * Get TimetableVersionRef value
     * @return \StructType\VersionRefStructure|null
     */
    public function getTimetableVersionRef()
    {
        return $this->TimetableVersionRef;
    }
    /**
     * Set TimetableVersionRef value
     * @param \StructType\VersionRefStructure $timetableVersionRef
     * @return \StructType\EstimatedTimetableRequestStructure
     */
    public function setTimetableVersionRef(\StructType\VersionRefStructure $timetableVersionRef = null)
    {
        $this->TimetableVersionRef = $timetableVersionRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\EstimatedTimetableRequestStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get Lines value
     * @return \StructType\Lines|null
     */
    public function getLines()
    {
        return $this->Lines;
    }
    /**
     * Set Lines value
     * @param \StructType\Lines $lines
     * @return \StructType\EstimatedTimetableRequestStructure
     */
    public function setLines(\StructType\Lines $lines = null)
    {
        $this->Lines = $lines;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\EstimatedTimetableRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get IncludeTranslations value
     * @return bool|null
     */
    public function getIncludeTranslations()
    {
        return $this->IncludeTranslations;
    }
    /**
     * Set IncludeTranslations value
     * @param bool $includeTranslations
     * @return \StructType\EstimatedTimetableRequestStructure
     */
    public function setIncludeTranslations($includeTranslations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTranslations) && !is_bool($includeTranslations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTranslations)), __LINE__);
        }
        $this->IncludeTranslations = $includeTranslations;
        return $this;
    }
    /**
     * Get EstimatedTimetableDetailLevel value
     * @return string|null
     */
    public function getEstimatedTimetableDetailLevel()
    {
        return $this->EstimatedTimetableDetailLevel;
    }
    /**
     * Set EstimatedTimetableDetailLevel value
     * @uses \EnumType\EstimatedTimetableDetailEnumeration::valueIsValid()
     * @uses \EnumType\EstimatedTimetableDetailEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $estimatedTimetableDetailLevel
     * @return \StructType\EstimatedTimetableRequestStructure
     */
    public function setEstimatedTimetableDetailLevel($estimatedTimetableDetailLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EstimatedTimetableDetailEnumeration::valueIsValid($estimatedTimetableDetailLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $estimatedTimetableDetailLevel, implode(', ', \EnumType\EstimatedTimetableDetailEnumeration::getValidValues())), __LINE__);
        }
        $this->EstimatedTimetableDetailLevel = $estimatedTimetableDetailLevel;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\EstimatedTimetableRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\EstimatedTimetableRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstimatedTimetableRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
