<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedServiceJourneyInterchangeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Estimated SERVICE JOURNEY INTERCHANGE.
 * @subpackage Structs
 */
class EstimatedServiceJourneyInterchangeStructure extends AbstractStructBase
{
    /**
     * The InterchangeRef
     * Meta informations extracted from the WSDL
     * - ref: InterchangeRef
     * @var \StructType\InterchangeRefStructure
     */
    public $InterchangeRef;
    /**
     * The FeederJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a connecting distributor VEHICLE JOURNEY. +SIRI v2.0
     * @var \StructType\ConnectingJourneyRefStructure
     */
    public $FeederJourneyRef;
    /**
     * The DistributorJourneyRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a connecting distributor VEHICLE JOURNEY. +SIRI v2.0
     * @var \StructType\ConnectingJourneyRefStructure
     */
    public $DistributorJourneyRef;
    /**
     * The WillNotWait
     * Meta informations extracted from the WSDL
     * - documentation: Distributor will not wait (i.e. connection broken) SIRI w.0
     * @var string
     */
    public $WillNotWait;
    /**
     * The WillWait
     * Meta informations extracted from the WSDL
     * - documentation: Nature of wait that distributer will make. +SIRI v2.0
     * @var \StructType\WillWaitStructure
     */
    public $WillWait;
    /**
     * The ExpectedDepartureTimeOfDistributor
     * Meta informations extracted from the WSDL
     * - documentation: Time at which distributor VEHICLE is expected to depart. +SIRI v2.0
     * - minOccurs: 0
     * @var string
     */
    public $ExpectedDepartureTimeOfDistributor;
    /**
     * The ConnectionMonitoring
     * Meta informations extracted from the WSDL
     * - documentation: Whether connection monitoring is active or not for this connection +SIRI v2.0
     * - minOccurs: 0
     * @var bool
     */
    public $ConnectionMonitoring;
    /**
     * Constructor method for EstimatedServiceJourneyInterchangeStructure
     * @uses EstimatedServiceJourneyInterchangeStructure::setInterchangeRef()
     * @uses EstimatedServiceJourneyInterchangeStructure::setFeederJourneyRef()
     * @uses EstimatedServiceJourneyInterchangeStructure::setDistributorJourneyRef()
     * @uses EstimatedServiceJourneyInterchangeStructure::setWillNotWait()
     * @uses EstimatedServiceJourneyInterchangeStructure::setWillWait()
     * @uses EstimatedServiceJourneyInterchangeStructure::setExpectedDepartureTimeOfDistributor()
     * @uses EstimatedServiceJourneyInterchangeStructure::setConnectionMonitoring()
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @param \StructType\ConnectingJourneyRefStructure $feederJourneyRef
     * @param \StructType\ConnectingJourneyRefStructure $distributorJourneyRef
     * @param string $willNotWait
     * @param \StructType\WillWaitStructure $willWait
     * @param string $expectedDepartureTimeOfDistributor
     * @param bool $connectionMonitoring
     */
    public function __construct(\StructType\InterchangeRefStructure $interchangeRef = null, \StructType\ConnectingJourneyRefStructure $feederJourneyRef = null, \StructType\ConnectingJourneyRefStructure $distributorJourneyRef = null, $willNotWait = null, \StructType\WillWaitStructure $willWait = null, $expectedDepartureTimeOfDistributor = null, $connectionMonitoring = null)
    {
        $this
            ->setInterchangeRef($interchangeRef)
            ->setFeederJourneyRef($feederJourneyRef)
            ->setDistributorJourneyRef($distributorJourneyRef)
            ->setWillNotWait($willNotWait)
            ->setWillWait($willWait)
            ->setExpectedDepartureTimeOfDistributor($expectedDepartureTimeOfDistributor)
            ->setConnectionMonitoring($connectionMonitoring);
    }
    /**
     * Get InterchangeRef value
     * @return \StructType\InterchangeRefStructure|null
     */
    public function getInterchangeRef()
    {
        return $this->InterchangeRef;
    }
    /**
     * Set InterchangeRef value
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @return \StructType\EstimatedServiceJourneyInterchangeStructure
     */
    public function setInterchangeRef(\StructType\InterchangeRefStructure $interchangeRef = null)
    {
        $this->InterchangeRef = $interchangeRef;
        return $this;
    }
    /**
     * Get FeederJourneyRef value
     * @return \StructType\ConnectingJourneyRefStructure|null
     */
    public function getFeederJourneyRef()
    {
        return $this->FeederJourneyRef;
    }
    /**
     * Set FeederJourneyRef value
     * @param \StructType\ConnectingJourneyRefStructure $feederJourneyRef
     * @return \StructType\EstimatedServiceJourneyInterchangeStructure
     */
    public function setFeederJourneyRef(\StructType\ConnectingJourneyRefStructure $feederJourneyRef = null)
    {
        $this->FeederJourneyRef = $feederJourneyRef;
        return $this;
    }
    /**
     * Get DistributorJourneyRef value
     * @return \StructType\ConnectingJourneyRefStructure|null
     */
    public function getDistributorJourneyRef()
    {
        return $this->DistributorJourneyRef;
    }
    /**
     * Set DistributorJourneyRef value
     * @param \StructType\ConnectingJourneyRefStructure $distributorJourneyRef
     * @return \StructType\EstimatedServiceJourneyInterchangeStructure
     */
    public function setDistributorJourneyRef(\StructType\ConnectingJourneyRefStructure $distributorJourneyRef = null)
    {
        $this->DistributorJourneyRef = $distributorJourneyRef;
        return $this;
    }
    /**
     * Get WillNotWait value
     * @return string|null
     */
    public function getWillNotWait()
    {
        return $this->WillNotWait;
    }
    /**
     * Set WillNotWait value
     * @uses \EnumType\EmptyType::valueIsValid()
     * @uses \EnumType\EmptyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $willNotWait
     * @return \StructType\EstimatedServiceJourneyInterchangeStructure
     */
    public function setWillNotWait($willNotWait = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmptyType::valueIsValid($willNotWait)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $willNotWait, implode(', ', \EnumType\EmptyType::getValidValues())), __LINE__);
        }
        $this->WillNotWait = $willNotWait;
        return $this;
    }
    /**
     * Get WillWait value
     * @return \StructType\WillWaitStructure|null
     */
    public function getWillWait()
    {
        return $this->WillWait;
    }
    /**
     * Set WillWait value
     * @param \StructType\WillWaitStructure $willWait
     * @return \StructType\EstimatedServiceJourneyInterchangeStructure
     */
    public function setWillWait(\StructType\WillWaitStructure $willWait = null)
    {
        $this->WillWait = $willWait;
        return $this;
    }
    /**
     * Get ExpectedDepartureTimeOfDistributor value
     * @return string|null
     */
    public function getExpectedDepartureTimeOfDistributor()
    {
        return $this->ExpectedDepartureTimeOfDistributor;
    }
    /**
     * Set ExpectedDepartureTimeOfDistributor value
     * @param string $expectedDepartureTimeOfDistributor
     * @return \StructType\EstimatedServiceJourneyInterchangeStructure
     */
    public function setExpectedDepartureTimeOfDistributor($expectedDepartureTimeOfDistributor = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDepartureTimeOfDistributor) && !is_string($expectedDepartureTimeOfDistributor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedDepartureTimeOfDistributor)), __LINE__);
        }
        $this->ExpectedDepartureTimeOfDistributor = $expectedDepartureTimeOfDistributor;
        return $this;
    }
    /**
     * Get ConnectionMonitoring value
     * @return bool|null
     */
    public function getConnectionMonitoring()
    {
        return $this->ConnectionMonitoring;
    }
    /**
     * Set ConnectionMonitoring value
     * @param bool $connectionMonitoring
     * @return \StructType\EstimatedServiceJourneyInterchangeStructure
     */
    public function setConnectionMonitoring($connectionMonitoring = null)
    {
        // validation for constraint: boolean
        if (!is_null($connectionMonitoring) && !is_bool($connectionMonitoring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($connectionMonitoring)), __LINE__);
        }
        $this->ConnectionMonitoring = $connectionMonitoring;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstimatedServiceJourneyInterchangeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
