<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedCalls StructType
 * Meta informations extracted from the WSDL
 * - documentation: Estimated call times for journey
 * @subpackage Structs
 */
class EstimatedCalls extends AbstractStructBase
{
    /**
     * The EstimatedCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: EstimatedCall
     * @var \StructType\EstimatedCallStructure[]
     */
    public $EstimatedCall;
    /**
     * Constructor method for EstimatedCalls
     * @uses EstimatedCalls::setEstimatedCall()
     * @param \StructType\EstimatedCallStructure[] $estimatedCall
     */
    public function __construct(array $estimatedCall = array())
    {
        $this
            ->setEstimatedCall($estimatedCall);
    }
    /**
     * Get EstimatedCall value
     * @return \StructType\EstimatedCallStructure[]|null
     */
    public function getEstimatedCall()
    {
        return $this->EstimatedCall;
    }
    /**
     * Set EstimatedCall value
     * @throws \InvalidArgumentException
     * @param \StructType\EstimatedCallStructure[] $estimatedCall
     * @return \StructType\EstimatedCalls
     */
    public function setEstimatedCall(array $estimatedCall = array())
    {
        foreach ($estimatedCall as $estimatedCallsEstimatedCallItem) {
            // validation for constraint: itemType
            if (!$estimatedCallsEstimatedCallItem instanceof \StructType\EstimatedCallStructure) {
                throw new \InvalidArgumentException(sprintf('The EstimatedCall property can only contain items of \StructType\EstimatedCallStructure, "%s" given', is_object($estimatedCallsEstimatedCallItem) ? get_class($estimatedCallsEstimatedCallItem) : gettype($estimatedCallsEstimatedCallItem)), __LINE__);
            }
        }
        $this->EstimatedCall = $estimatedCall;
        return $this;
    }
    /**
     * Add item to EstimatedCall value
     * @throws \InvalidArgumentException
     * @param \StructType\EstimatedCallStructure $item
     * @return \StructType\EstimatedCalls
     */
    public function addToEstimatedCall(\StructType\EstimatedCallStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EstimatedCallStructure) {
            throw new \InvalidArgumentException(sprintf('The EstimatedCall property can only contain items of \StructType\EstimatedCallStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EstimatedCall[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstimatedCalls
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
