<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorConditionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for RequestErrorCondition.
 * @subpackage Structs
 */
class ErrorConditionStructure extends AbstractStructBase
{
    /**
     * The ServiceNotAvailableError
     * @var \StructType\ServiceNotAvailableErrorStructure
     */
    public $ServiceNotAvailableError;
    /**
     * The CapabilityNotSupportedError
     * @var \StructType\CapabilityNotSupportedErrorStructure
     */
    public $CapabilityNotSupportedError;
    /**
     * The AccessNotAllowedError
     * @var \StructType\AccessNotAllowedErrorStructure
     */
    public $AccessNotAllowedError;
    /**
     * The InvalidDataReferencesError
     * @var \StructType\InvalidDataReferencesErrorStructure
     */
    public $InvalidDataReferencesError;
    /**
     * The BeyondDataHorizon
     * @var \StructType\BeyondDataHorizonErrorStructure
     */
    public $BeyondDataHorizon;
    /**
     * The NoInfoForTopicError
     * @var \StructType\NoInfoForTopicErrorStructure
     */
    public $NoInfoForTopicError;
    /**
     * The ParametersIgnoredError
     * @var \StructType\ParametersIgnoredErrorStructure
     */
    public $ParametersIgnoredError;
    /**
     * The UnknownExtensionsError
     * @var \StructType\UnknownExtensionsErrorStructure
     */
    public $UnknownExtensionsError;
    /**
     * The AllowedResourceUsageExceededError
     * @var \StructType\AllowedResourceUsageExceededErrorStructure
     */
    public $AllowedResourceUsageExceededError;
    /**
     * The OtherError
     * @var \StructType\OtherErrorStructure
     */
    public $OtherError;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Text description of error.
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $Description;
    /**
     * Constructor method for ErrorConditionStructure
     * @uses ErrorConditionStructure::setServiceNotAvailableError()
     * @uses ErrorConditionStructure::setCapabilityNotSupportedError()
     * @uses ErrorConditionStructure::setAccessNotAllowedError()
     * @uses ErrorConditionStructure::setInvalidDataReferencesError()
     * @uses ErrorConditionStructure::setBeyondDataHorizon()
     * @uses ErrorConditionStructure::setNoInfoForTopicError()
     * @uses ErrorConditionStructure::setParametersIgnoredError()
     * @uses ErrorConditionStructure::setUnknownExtensionsError()
     * @uses ErrorConditionStructure::setAllowedResourceUsageExceededError()
     * @uses ErrorConditionStructure::setOtherError()
     * @uses ErrorConditionStructure::setDescription()
     * @param \StructType\ServiceNotAvailableErrorStructure $serviceNotAvailableError
     * @param \StructType\CapabilityNotSupportedErrorStructure $capabilityNotSupportedError
     * @param \StructType\AccessNotAllowedErrorStructure $accessNotAllowedError
     * @param \StructType\InvalidDataReferencesErrorStructure $invalidDataReferencesError
     * @param \StructType\BeyondDataHorizonErrorStructure $beyondDataHorizon
     * @param \StructType\NoInfoForTopicErrorStructure $noInfoForTopicError
     * @param \StructType\ParametersIgnoredErrorStructure $parametersIgnoredError
     * @param \StructType\UnknownExtensionsErrorStructure $unknownExtensionsError
     * @param \StructType\AllowedResourceUsageExceededErrorStructure $allowedResourceUsageExceededError
     * @param \StructType\OtherErrorStructure $otherError
     * @param \StructType\NaturalLanguageStringStructure $description
     */
    public function __construct(\StructType\ServiceNotAvailableErrorStructure $serviceNotAvailableError = null, \StructType\CapabilityNotSupportedErrorStructure $capabilityNotSupportedError = null, \StructType\AccessNotAllowedErrorStructure $accessNotAllowedError = null, \StructType\InvalidDataReferencesErrorStructure $invalidDataReferencesError = null, \StructType\BeyondDataHorizonErrorStructure $beyondDataHorizon = null, \StructType\NoInfoForTopicErrorStructure $noInfoForTopicError = null, \StructType\ParametersIgnoredErrorStructure $parametersIgnoredError = null, \StructType\UnknownExtensionsErrorStructure $unknownExtensionsError = null, \StructType\AllowedResourceUsageExceededErrorStructure $allowedResourceUsageExceededError = null, \StructType\OtherErrorStructure $otherError = null, \StructType\NaturalLanguageStringStructure $description = null)
    {
        $this
            ->setServiceNotAvailableError($serviceNotAvailableError)
            ->setCapabilityNotSupportedError($capabilityNotSupportedError)
            ->setAccessNotAllowedError($accessNotAllowedError)
            ->setInvalidDataReferencesError($invalidDataReferencesError)
            ->setBeyondDataHorizon($beyondDataHorizon)
            ->setNoInfoForTopicError($noInfoForTopicError)
            ->setParametersIgnoredError($parametersIgnoredError)
            ->setUnknownExtensionsError($unknownExtensionsError)
            ->setAllowedResourceUsageExceededError($allowedResourceUsageExceededError)
            ->setOtherError($otherError)
            ->setDescription($description);
    }
    /**
     * Get ServiceNotAvailableError value
     * @return \StructType\ServiceNotAvailableErrorStructure|null
     */
    public function getServiceNotAvailableError()
    {
        return $this->ServiceNotAvailableError;
    }
    /**
     * Set ServiceNotAvailableError value
     * @param \StructType\ServiceNotAvailableErrorStructure $serviceNotAvailableError
     * @return \StructType\ErrorConditionStructure
     */
    public function setServiceNotAvailableError(\StructType\ServiceNotAvailableErrorStructure $serviceNotAvailableError = null)
    {
        $this->ServiceNotAvailableError = $serviceNotAvailableError;
        return $this;
    }
    /**
     * Get CapabilityNotSupportedError value
     * @return \StructType\CapabilityNotSupportedErrorStructure|null
     */
    public function getCapabilityNotSupportedError()
    {
        return $this->CapabilityNotSupportedError;
    }
    /**
     * Set CapabilityNotSupportedError value
     * @param \StructType\CapabilityNotSupportedErrorStructure $capabilityNotSupportedError
     * @return \StructType\ErrorConditionStructure
     */
    public function setCapabilityNotSupportedError(\StructType\CapabilityNotSupportedErrorStructure $capabilityNotSupportedError = null)
    {
        $this->CapabilityNotSupportedError = $capabilityNotSupportedError;
        return $this;
    }
    /**
     * Get AccessNotAllowedError value
     * @return \StructType\AccessNotAllowedErrorStructure|null
     */
    public function getAccessNotAllowedError()
    {
        return $this->AccessNotAllowedError;
    }
    /**
     * Set AccessNotAllowedError value
     * @param \StructType\AccessNotAllowedErrorStructure $accessNotAllowedError
     * @return \StructType\ErrorConditionStructure
     */
    public function setAccessNotAllowedError(\StructType\AccessNotAllowedErrorStructure $accessNotAllowedError = null)
    {
        $this->AccessNotAllowedError = $accessNotAllowedError;
        return $this;
    }
    /**
     * Get InvalidDataReferencesError value
     * @return \StructType\InvalidDataReferencesErrorStructure|null
     */
    public function getInvalidDataReferencesError()
    {
        return $this->InvalidDataReferencesError;
    }
    /**
     * Set InvalidDataReferencesError value
     * @param \StructType\InvalidDataReferencesErrorStructure $invalidDataReferencesError
     * @return \StructType\ErrorConditionStructure
     */
    public function setInvalidDataReferencesError(\StructType\InvalidDataReferencesErrorStructure $invalidDataReferencesError = null)
    {
        $this->InvalidDataReferencesError = $invalidDataReferencesError;
        return $this;
    }
    /**
     * Get BeyondDataHorizon value
     * @return \StructType\BeyondDataHorizonErrorStructure|null
     */
    public function getBeyondDataHorizon()
    {
        return $this->BeyondDataHorizon;
    }
    /**
     * Set BeyondDataHorizon value
     * @param \StructType\BeyondDataHorizonErrorStructure $beyondDataHorizon
     * @return \StructType\ErrorConditionStructure
     */
    public function setBeyondDataHorizon(\StructType\BeyondDataHorizonErrorStructure $beyondDataHorizon = null)
    {
        $this->BeyondDataHorizon = $beyondDataHorizon;
        return $this;
    }
    /**
     * Get NoInfoForTopicError value
     * @return \StructType\NoInfoForTopicErrorStructure|null
     */
    public function getNoInfoForTopicError()
    {
        return $this->NoInfoForTopicError;
    }
    /**
     * Set NoInfoForTopicError value
     * @param \StructType\NoInfoForTopicErrorStructure $noInfoForTopicError
     * @return \StructType\ErrorConditionStructure
     */
    public function setNoInfoForTopicError(\StructType\NoInfoForTopicErrorStructure $noInfoForTopicError = null)
    {
        $this->NoInfoForTopicError = $noInfoForTopicError;
        return $this;
    }
    /**
     * Get ParametersIgnoredError value
     * @return \StructType\ParametersIgnoredErrorStructure|null
     */
    public function getParametersIgnoredError()
    {
        return $this->ParametersIgnoredError;
    }
    /**
     * Set ParametersIgnoredError value
     * @param \StructType\ParametersIgnoredErrorStructure $parametersIgnoredError
     * @return \StructType\ErrorConditionStructure
     */
    public function setParametersIgnoredError(\StructType\ParametersIgnoredErrorStructure $parametersIgnoredError = null)
    {
        $this->ParametersIgnoredError = $parametersIgnoredError;
        return $this;
    }
    /**
     * Get UnknownExtensionsError value
     * @return \StructType\UnknownExtensionsErrorStructure|null
     */
    public function getUnknownExtensionsError()
    {
        return $this->UnknownExtensionsError;
    }
    /**
     * Set UnknownExtensionsError value
     * @param \StructType\UnknownExtensionsErrorStructure $unknownExtensionsError
     * @return \StructType\ErrorConditionStructure
     */
    public function setUnknownExtensionsError(\StructType\UnknownExtensionsErrorStructure $unknownExtensionsError = null)
    {
        $this->UnknownExtensionsError = $unknownExtensionsError;
        return $this;
    }
    /**
     * Get AllowedResourceUsageExceededError value
     * @return \StructType\AllowedResourceUsageExceededErrorStructure|null
     */
    public function getAllowedResourceUsageExceededError()
    {
        return $this->AllowedResourceUsageExceededError;
    }
    /**
     * Set AllowedResourceUsageExceededError value
     * @param \StructType\AllowedResourceUsageExceededErrorStructure $allowedResourceUsageExceededError
     * @return \StructType\ErrorConditionStructure
     */
    public function setAllowedResourceUsageExceededError(\StructType\AllowedResourceUsageExceededErrorStructure $allowedResourceUsageExceededError = null)
    {
        $this->AllowedResourceUsageExceededError = $allowedResourceUsageExceededError;
        return $this;
    }
    /**
     * Get OtherError value
     * @return \StructType\OtherErrorStructure|null
     */
    public function getOtherError()
    {
        return $this->OtherError;
    }
    /**
     * Set OtherError value
     * @param \StructType\OtherErrorStructure $otherError
     * @return \StructType\ErrorConditionStructure
     */
    public function setOtherError(\StructType\OtherErrorStructure $otherError = null)
    {
        $this->OtherError = $otherError;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\NaturalLanguageStringStructure $description
     * @return \StructType\ErrorConditionStructure
     */
    public function setDescription(\StructType\NaturalLanguageStringStructure $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ErrorConditionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
