<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorCodeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Error Code.
 * @subpackage Structs
 */
class ErrorCodeStructure extends AbstractStructBase
{
    /**
     * The ErrorText
     * Meta informations extracted from the WSDL
     * - documentation: Addtional Description of error. This allows a descripotion to be supplied when the Error code is used in a specific WSDL fault, rather than within a general error condition.
     * - minOccurs: 0
     * @var string
     */
    public $ErrorText;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - documentation: Error code number associated with error.
     * @var int
     */
    public $number;
    /**
     * Constructor method for ErrorCodeStructure
     * @uses ErrorCodeStructure::setErrorText()
     * @uses ErrorCodeStructure::setNumber()
     * @param string $errorText
     * @param int $number
     */
    public function __construct($errorText = null, $number = null)
    {
        $this
            ->setErrorText($errorText)
            ->setNumber($number);
    }
    /**
     * Get ErrorText value
     * @return string|null
     */
    public function getErrorText()
    {
        return $this->ErrorText;
    }
    /**
     * Set ErrorText value
     * @param string $errorText
     * @return \StructType\ErrorCodeStructure
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorText)), __LINE__);
        }
        $this->ErrorText = $errorText;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \StructType\ErrorCodeStructure
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !is_numeric($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ErrorCodeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
