<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentOrSystemFault StructType
 * @subpackage Structs
 */
class EquipmentOrSystemFault extends TrafficElement
{
    /**
     * The equipmentOrSystemFaultType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $equipmentOrSystemFaultType;
    /**
     * The faultyEquipmentOrSystemType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $faultyEquipmentOrSystemType;
    /**
     * The equipmentOrSystemFaultExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $equipmentOrSystemFaultExtension;
    /**
     * Constructor method for EquipmentOrSystemFault
     * @uses EquipmentOrSystemFault::setEquipmentOrSystemFaultType()
     * @uses EquipmentOrSystemFault::setFaultyEquipmentOrSystemType()
     * @uses EquipmentOrSystemFault::setEquipmentOrSystemFaultExtension()
     * @param string $equipmentOrSystemFaultType
     * @param string $faultyEquipmentOrSystemType
     * @param \StructType\ExtensionType $equipmentOrSystemFaultExtension
     */
    public function __construct($equipmentOrSystemFaultType = null, $faultyEquipmentOrSystemType = null, \StructType\ExtensionType $equipmentOrSystemFaultExtension = null)
    {
        $this
            ->setEquipmentOrSystemFaultType($equipmentOrSystemFaultType)
            ->setFaultyEquipmentOrSystemType($faultyEquipmentOrSystemType)
            ->setEquipmentOrSystemFaultExtension($equipmentOrSystemFaultExtension);
    }
    /**
     * Get equipmentOrSystemFaultType value
     * @return string
     */
    public function getEquipmentOrSystemFaultType()
    {
        return $this->equipmentOrSystemFaultType;
    }
    /**
     * Set equipmentOrSystemFaultType value
     * @uses \EnumType\EquipmentOrSystemFaultTypeEnum::valueIsValid()
     * @uses \EnumType\EquipmentOrSystemFaultTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $equipmentOrSystemFaultType
     * @return \StructType\EquipmentOrSystemFault
     */
    public function setEquipmentOrSystemFaultType($equipmentOrSystemFaultType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EquipmentOrSystemFaultTypeEnum::valueIsValid($equipmentOrSystemFaultType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $equipmentOrSystemFaultType, implode(', ', \EnumType\EquipmentOrSystemFaultTypeEnum::getValidValues())), __LINE__);
        }
        $this->equipmentOrSystemFaultType = $equipmentOrSystemFaultType;
        return $this;
    }
    /**
     * Get faultyEquipmentOrSystemType value
     * @return string
     */
    public function getFaultyEquipmentOrSystemType()
    {
        return $this->faultyEquipmentOrSystemType;
    }
    /**
     * Set faultyEquipmentOrSystemType value
     * @uses \EnumType\EquipmentOrSystemTypeEnum::valueIsValid()
     * @uses \EnumType\EquipmentOrSystemTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $faultyEquipmentOrSystemType
     * @return \StructType\EquipmentOrSystemFault
     */
    public function setFaultyEquipmentOrSystemType($faultyEquipmentOrSystemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EquipmentOrSystemTypeEnum::valueIsValid($faultyEquipmentOrSystemType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $faultyEquipmentOrSystemType, implode(', ', \EnumType\EquipmentOrSystemTypeEnum::getValidValues())), __LINE__);
        }
        $this->faultyEquipmentOrSystemType = $faultyEquipmentOrSystemType;
        return $this;
    }
    /**
     * Get equipmentOrSystemFaultExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getEquipmentOrSystemFaultExtension()
    {
        return $this->equipmentOrSystemFaultExtension;
    }
    /**
     * Set equipmentOrSystemFaultExtension value
     * @param \StructType\ExtensionType $equipmentOrSystemFaultExtension
     * @return \StructType\EquipmentOrSystemFault
     */
    public function setEquipmentOrSystemFaultExtension(\StructType\ExtensionType $equipmentOrSystemFaultExtension = null)
    {
        $this->equipmentOrSystemFaultExtension = $equipmentOrSystemFaultExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EquipmentOrSystemFault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
