<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentFeatures StructType
 * Meta informations extracted from the WSDL
 * - documentation: Service Features associated with equipment.
 * @subpackage Structs
 */
class EquipmentFeatures extends AbstractStructBase
{
    /**
     * The FeatureRef
     * Meta informations extracted from the WSDL
     * - documentation: Service or Stop features associated with equipment. Recommended values based on TPEG are given in SIRI documentation and enumerated in the siri_facilities package.
     * - maxOccurs: unbounded
     * @var \StructType\FeatureRefStructure[]
     */
    public $FeatureRef;
    /**
     * Constructor method for EquipmentFeatures
     * @uses EquipmentFeatures::setFeatureRef()
     * @param \StructType\FeatureRefStructure[] $featureRef
     */
    public function __construct(array $featureRef = array())
    {
        $this
            ->setFeatureRef($featureRef);
    }
    /**
     * Get FeatureRef value
     * @return \StructType\FeatureRefStructure[]|null
     */
    public function getFeatureRef()
    {
        return $this->FeatureRef;
    }
    /**
     * Set FeatureRef value
     * @throws \InvalidArgumentException
     * @param \StructType\FeatureRefStructure[] $featureRef
     * @return \StructType\EquipmentFeatures
     */
    public function setFeatureRef(array $featureRef = array())
    {
        foreach ($featureRef as $equipmentFeaturesFeatureRefItem) {
            // validation for constraint: itemType
            if (!$equipmentFeaturesFeatureRefItem instanceof \StructType\FeatureRefStructure) {
                throw new \InvalidArgumentException(sprintf('The FeatureRef property can only contain items of \StructType\FeatureRefStructure, "%s" given', is_object($equipmentFeaturesFeatureRefItem) ? get_class($equipmentFeaturesFeatureRefItem) : gettype($equipmentFeaturesFeatureRefItem)), __LINE__);
            }
        }
        $this->FeatureRef = $featureRef;
        return $this;
    }
    /**
     * Add item to FeatureRef value
     * @throws \InvalidArgumentException
     * @param \StructType\FeatureRefStructure $item
     * @return \StructType\EquipmentFeatures
     */
    public function addToFeatureRef(\StructType\FeatureRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeatureRefStructure) {
            throw new \InvalidArgumentException(sprintf('The FeatureRef property can only contain items of \StructType\FeatureRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FeatureRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EquipmentFeatures
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
