<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnvironmentalObstruction StructType
 * @subpackage Structs
 */
class EnvironmentalObstruction extends Obstruction
{
    /**
     * The environmentalObstructionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $environmentalObstructionType;
    /**
     * The depth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $depth;
    /**
     * The environmentalObstructionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $environmentalObstructionExtension;
    /**
     * Constructor method for EnvironmentalObstruction
     * @uses EnvironmentalObstruction::setEnvironmentalObstructionType()
     * @uses EnvironmentalObstruction::setDepth()
     * @uses EnvironmentalObstruction::setEnvironmentalObstructionExtension()
     * @param string $environmentalObstructionType
     * @param float $depth
     * @param \StructType\ExtensionType $environmentalObstructionExtension
     */
    public function __construct($environmentalObstructionType = null, $depth = null, \StructType\ExtensionType $environmentalObstructionExtension = null)
    {
        $this
            ->setEnvironmentalObstructionType($environmentalObstructionType)
            ->setDepth($depth)
            ->setEnvironmentalObstructionExtension($environmentalObstructionExtension);
    }
    /**
     * Get environmentalObstructionType value
     * @return string
     */
    public function getEnvironmentalObstructionType()
    {
        return $this->environmentalObstructionType;
    }
    /**
     * Set environmentalObstructionType value
     * @uses \EnumType\EnvironmentalObstructionTypeEnum::valueIsValid()
     * @uses \EnumType\EnvironmentalObstructionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $environmentalObstructionType
     * @return \StructType\EnvironmentalObstruction
     */
    public function setEnvironmentalObstructionType($environmentalObstructionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnvironmentalObstructionTypeEnum::valueIsValid($environmentalObstructionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $environmentalObstructionType, implode(', ', \EnumType\EnvironmentalObstructionTypeEnum::getValidValues())), __LINE__);
        }
        $this->environmentalObstructionType = $environmentalObstructionType;
        return $this;
    }
    /**
     * Get depth value
     * @return float|null
     */
    public function getDepth()
    {
        return $this->depth;
    }
    /**
     * Set depth value
     * @param float $depth
     * @return \StructType\EnvironmentalObstruction
     */
    public function setDepth($depth = null)
    {
        $this->depth = $depth;
        return $this;
    }
    /**
     * Get environmentalObstructionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getEnvironmentalObstructionExtension()
    {
        return $this->environmentalObstructionExtension;
    }
    /**
     * Set environmentalObstructionExtension value
     * @param \StructType\ExtensionType $environmentalObstructionExtension
     * @return \StructType\EnvironmentalObstruction
     */
    public function setEnvironmentalObstructionExtension(\StructType\ExtensionType $environmentalObstructionExtension = null)
    {
        $this->environmentalObstructionExtension = $environmentalObstructionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EnvironmentalObstruction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
