<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElaboratedDataPublication StructType
 * @subpackage Structs
 */
class ElaboratedDataPublication extends PayloadPublication
{
    /**
     * The forecastDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $forecastDefault;
    /**
     * The periodDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $periodDefault;
    /**
     * The timeDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeDefault;
    /**
     * The headerInformation
     * @var \StructType\HeaderInformation
     */
    public $headerInformation;
    /**
     * The referenceSettings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReferenceSettings
     */
    public $referenceSettings;
    /**
     * The elaboratedData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ElaboratedData[]
     */
    public $elaboratedData;
    /**
     * The elaboratedDataPublicationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $elaboratedDataPublicationExtension;
    /**
     * Constructor method for ElaboratedDataPublication
     * @uses ElaboratedDataPublication::setForecastDefault()
     * @uses ElaboratedDataPublication::setPeriodDefault()
     * @uses ElaboratedDataPublication::setTimeDefault()
     * @uses ElaboratedDataPublication::setHeaderInformation()
     * @uses ElaboratedDataPublication::setReferenceSettings()
     * @uses ElaboratedDataPublication::setElaboratedData()
     * @uses ElaboratedDataPublication::setElaboratedDataPublicationExtension()
     * @param bool $forecastDefault
     * @param float $periodDefault
     * @param string $timeDefault
     * @param \StructType\HeaderInformation $headerInformation
     * @param \StructType\ReferenceSettings $referenceSettings
     * @param \StructType\ElaboratedData[] $elaboratedData
     * @param \StructType\ExtensionType $elaboratedDataPublicationExtension
     */
    public function __construct($forecastDefault = null, $periodDefault = null, $timeDefault = null, \StructType\HeaderInformation $headerInformation = null, \StructType\ReferenceSettings $referenceSettings = null, array $elaboratedData = array(), \StructType\ExtensionType $elaboratedDataPublicationExtension = null)
    {
        $this
            ->setForecastDefault($forecastDefault)
            ->setPeriodDefault($periodDefault)
            ->setTimeDefault($timeDefault)
            ->setHeaderInformation($headerInformation)
            ->setReferenceSettings($referenceSettings)
            ->setElaboratedData($elaboratedData)
            ->setElaboratedDataPublicationExtension($elaboratedDataPublicationExtension);
    }
    /**
     * Get forecastDefault value
     * @return bool|null
     */
    public function getForecastDefault()
    {
        return $this->forecastDefault;
    }
    /**
     * Set forecastDefault value
     * @param bool $forecastDefault
     * @return \StructType\ElaboratedDataPublication
     */
    public function setForecastDefault($forecastDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($forecastDefault) && !is_bool($forecastDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forecastDefault)), __LINE__);
        }
        $this->forecastDefault = $forecastDefault;
        return $this;
    }
    /**
     * Get periodDefault value
     * @return float|null
     */
    public function getPeriodDefault()
    {
        return $this->periodDefault;
    }
    /**
     * Set periodDefault value
     * @param float $periodDefault
     * @return \StructType\ElaboratedDataPublication
     */
    public function setPeriodDefault($periodDefault = null)
    {
        $this->periodDefault = $periodDefault;
        return $this;
    }
    /**
     * Get timeDefault value
     * @return string|null
     */
    public function getTimeDefault()
    {
        return $this->timeDefault;
    }
    /**
     * Set timeDefault value
     * @param string $timeDefault
     * @return \StructType\ElaboratedDataPublication
     */
    public function setTimeDefault($timeDefault = null)
    {
        // validation for constraint: string
        if (!is_null($timeDefault) && !is_string($timeDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeDefault)), __LINE__);
        }
        $this->timeDefault = $timeDefault;
        return $this;
    }
    /**
     * Get headerInformation value
     * @return \StructType\HeaderInformation|null
     */
    public function getHeaderInformation()
    {
        return $this->headerInformation;
    }
    /**
     * Set headerInformation value
     * @param \StructType\HeaderInformation $headerInformation
     * @return \StructType\ElaboratedDataPublication
     */
    public function setHeaderInformation(\StructType\HeaderInformation $headerInformation = null)
    {
        $this->headerInformation = $headerInformation;
        return $this;
    }
    /**
     * Get referenceSettings value
     * @return \StructType\ReferenceSettings|null
     */
    public function getReferenceSettings()
    {
        return $this->referenceSettings;
    }
    /**
     * Set referenceSettings value
     * @param \StructType\ReferenceSettings $referenceSettings
     * @return \StructType\ElaboratedDataPublication
     */
    public function setReferenceSettings(\StructType\ReferenceSettings $referenceSettings = null)
    {
        $this->referenceSettings = $referenceSettings;
        return $this;
    }
    /**
     * Get elaboratedData value
     * @return \StructType\ElaboratedData[]|null
     */
    public function getElaboratedData()
    {
        return $this->elaboratedData;
    }
    /**
     * Set elaboratedData value
     * @throws \InvalidArgumentException
     * @param \StructType\ElaboratedData[] $elaboratedData
     * @return \StructType\ElaboratedDataPublication
     */
    public function setElaboratedData(array $elaboratedData = array())
    {
        foreach ($elaboratedData as $elaboratedDataPublicationElaboratedDataItem) {
            // validation for constraint: itemType
            if (!$elaboratedDataPublicationElaboratedDataItem instanceof \StructType\ElaboratedData) {
                throw new \InvalidArgumentException(sprintf('The elaboratedData property can only contain items of \StructType\ElaboratedData, "%s" given', is_object($elaboratedDataPublicationElaboratedDataItem) ? get_class($elaboratedDataPublicationElaboratedDataItem) : gettype($elaboratedDataPublicationElaboratedDataItem)), __LINE__);
            }
        }
        $this->elaboratedData = $elaboratedData;
        return $this;
    }
    /**
     * Add item to elaboratedData value
     * @throws \InvalidArgumentException
     * @param \StructType\ElaboratedData $item
     * @return \StructType\ElaboratedDataPublication
     */
    public function addToElaboratedData(\StructType\ElaboratedData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ElaboratedData) {
            throw new \InvalidArgumentException(sprintf('The elaboratedData property can only contain items of \StructType\ElaboratedData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->elaboratedData[] = $item;
        return $this;
    }
    /**
     * Get elaboratedDataPublicationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getElaboratedDataPublicationExtension()
    {
        return $this->elaboratedDataPublicationExtension;
    }
    /**
     * Set elaboratedDataPublicationExtension value
     * @param \StructType\ExtensionType $elaboratedDataPublicationExtension
     * @return \StructType\ElaboratedDataPublication
     */
    public function setElaboratedDataPublicationExtension(\StructType\ExtensionType $elaboratedDataPublicationExtension = null)
    {
        $this->elaboratedDataPublicationExtension = $elaboratedDataPublicationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ElaboratedDataPublication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
