<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElaboratedData StructType
 * @subpackage Structs
 */
class ElaboratedData extends AbstractStructBase
{
    /**
     * The forecast
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $forecast;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Source
     */
    public $source;
    /**
     * The validity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Validity
     */
    public $validity;
    /**
     * The basicDataValue
     * @var \StructType\BasicDataValue
     */
    public $basicDataValue;
    /**
     * The elaboratedDataExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $elaboratedDataExtension;
    /**
     * Constructor method for ElaboratedData
     * @uses ElaboratedData::setForecast()
     * @uses ElaboratedData::setSource()
     * @uses ElaboratedData::setValidity()
     * @uses ElaboratedData::setBasicDataValue()
     * @uses ElaboratedData::setElaboratedDataExtension()
     * @param bool $forecast
     * @param \StructType\Source $source
     * @param \StructType\Validity $validity
     * @param \StructType\BasicDataValue $basicDataValue
     * @param \StructType\ExtensionType $elaboratedDataExtension
     */
    public function __construct($forecast = null, \StructType\Source $source = null, \StructType\Validity $validity = null, \StructType\BasicDataValue $basicDataValue = null, \StructType\ExtensionType $elaboratedDataExtension = null)
    {
        $this
            ->setForecast($forecast)
            ->setSource($source)
            ->setValidity($validity)
            ->setBasicDataValue($basicDataValue)
            ->setElaboratedDataExtension($elaboratedDataExtension);
    }
    /**
     * Get forecast value
     * @return bool|null
     */
    public function getForecast()
    {
        return $this->forecast;
    }
    /**
     * Set forecast value
     * @param bool $forecast
     * @return \StructType\ElaboratedData
     */
    public function setForecast($forecast = null)
    {
        // validation for constraint: boolean
        if (!is_null($forecast) && !is_bool($forecast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forecast)), __LINE__);
        }
        $this->forecast = $forecast;
        return $this;
    }
    /**
     * Get source value
     * @return \StructType\Source|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param \StructType\Source $source
     * @return \StructType\ElaboratedData
     */
    public function setSource(\StructType\Source $source = null)
    {
        $this->source = $source;
        return $this;
    }
    /**
     * Get validity value
     * @return \StructType\Validity|null
     */
    public function getValidity()
    {
        return $this->validity;
    }
    /**
     * Set validity value
     * @param \StructType\Validity $validity
     * @return \StructType\ElaboratedData
     */
    public function setValidity(\StructType\Validity $validity = null)
    {
        $this->validity = $validity;
        return $this;
    }
    /**
     * Get basicDataValue value
     * @return \StructType\BasicDataValue|null
     */
    public function getBasicDataValue()
    {
        return $this->basicDataValue;
    }
    /**
     * Set basicDataValue value
     * @param \StructType\BasicDataValue $basicDataValue
     * @return \StructType\ElaboratedData
     */
    public function setBasicDataValue(\StructType\BasicDataValue $basicDataValue = null)
    {
        $this->basicDataValue = $basicDataValue;
        return $this;
    }
    /**
     * Get elaboratedDataExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getElaboratedDataExtension()
    {
        return $this->elaboratedDataExtension;
    }
    /**
     * Set elaboratedDataExtension value
     * @param \StructType\ExtensionType $elaboratedDataExtension
     * @return \StructType\ElaboratedData
     */
    public function setElaboratedDataExtension(\StructType\ExtensionType $elaboratedDataExtension = null)
    {
        $this->elaboratedDataExtension = $elaboratedDataExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ElaboratedData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
