<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributorDepartureCancellationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Cancellation of a Distributor VEHICLE JOURNEY from a connection.
 * @subpackage Structs
 */
class DistributorDepartureCancellationStructure extends AbstractDistributorItemStructure
{
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - documentation: Reason for failure of connection. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Reason;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for DistributorDepartureCancellationStructure
     * @uses DistributorDepartureCancellationStructure::setReason()
     * @uses DistributorDepartureCancellationStructure::setExtensions()
     * @param \StructType\NaturalLanguageStringStructure[] $reason
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(array $reason = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setReason($reason)
            ->setExtensions($extensions);
    }
    /**
     * Get Reason value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $reason
     * @return \StructType\DistributorDepartureCancellationStructure
     */
    public function setReason(array $reason = array())
    {
        foreach ($reason as $distributorDepartureCancellationStructureReasonItem) {
            // validation for constraint: itemType
            if (!$distributorDepartureCancellationStructureReasonItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Reason property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($distributorDepartureCancellationStructureReasonItem) ? get_class($distributorDepartureCancellationStructureReasonItem) : gettype($distributorDepartureCancellationStructureReasonItem)), __LINE__);
            }
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Add item to Reason value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\DistributorDepartureCancellationStructure
     */
    public function addToReason(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Reason property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Reason[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\DistributorDepartureCancellationStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistributorDepartureCancellationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
