<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Destination StructType
 * Meta informations extracted from the WSDL
 * - documentation: Destination of VEHICLE JOURNEY. | Description of a DESTINATION.
 * - minOccurs: 0
 * - type: AnnotatedDestinationStructure
 * @subpackage Structs
 */
abstract class Destination extends AbstractStructBase
{
    /**
     * The DestinationRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: DestinationRef
     * @var \StructType\DestinationRefStructure
     */
    public $DestinationRef;
    /**
     * The DestinationName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: DestinationName
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $DestinationName;
    /**
     * The destinationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $destinationExtension;
    /**
     * Constructor method for Destination
     * @uses Destination::setDestinationRef()
     * @uses Destination::setDestinationName()
     * @uses Destination::setDestinationExtension()
     * @param \StructType\DestinationRefStructure $destinationRef
     * @param \StructType\NaturalLanguagePlaceNameStructure $destinationName
     * @param \StructType\ExtensionType $destinationExtension
     */
    public function __construct(\StructType\DestinationRefStructure $destinationRef = null, \StructType\NaturalLanguagePlaceNameStructure $destinationName = null, \StructType\ExtensionType $destinationExtension = null)
    {
        $this
            ->setDestinationRef($destinationRef)
            ->setDestinationName($destinationName)
            ->setDestinationExtension($destinationExtension);
    }
    /**
     * Get DestinationRef value
     * @return \StructType\DestinationRefStructure|null
     */
    public function getDestinationRef()
    {
        return $this->DestinationRef;
    }
    /**
     * Set DestinationRef value
     * @param \StructType\DestinationRefStructure $destinationRef
     * @return \StructType\Destination
     */
    public function setDestinationRef(\StructType\DestinationRefStructure $destinationRef = null)
    {
        $this->DestinationRef = $destinationRef;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param \StructType\NaturalLanguagePlaceNameStructure $destinationName
     * @return \StructType\Destination
     */
    public function setDestinationName(\StructType\NaturalLanguagePlaceNameStructure $destinationName = null)
    {
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get destinationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getDestinationExtension()
    {
        return $this->destinationExtension;
    }
    /**
     * Set destinationExtension value
     * @param \StructType\ExtensionType $destinationExtension
     * @return \StructType\Destination
     */
    public function setDestinationExtension(\StructType\ExtensionType $destinationExtension = null)
    {
        $this->destinationExtension = $destinationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Destination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
