<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryVariantStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Delviery Variant +SIRI v2.0
 * @subpackage Structs
 */
class DeliveryVariantStructure extends AbstractStructBase
{
    /**
     * The VariantType
     * Meta informations extracted from the WSDL
     * - documentation: Classification of DELIVERY VARIANT +SIRI v2.0.
     * - minOccurs: 0
     * @var string
     */
    public $VariantType;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - documentation: Variant text. SIRI v".0
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $Content;
    /**
     * Constructor method for DeliveryVariantStructure
     * @uses DeliveryVariantStructure::setVariantType()
     * @uses DeliveryVariantStructure::setContent()
     * @param string $variantType
     * @param \StructType\NaturalLanguageStringStructure $content
     */
    public function __construct($variantType = null, \StructType\NaturalLanguageStringStructure $content = null)
    {
        $this
            ->setVariantType($variantType)
            ->setContent($content);
    }
    /**
     * Get VariantType value
     * @return string|null
     */
    public function getVariantType()
    {
        return $this->VariantType;
    }
    /**
     * Set VariantType value
     * @param string $variantType
     * @return \StructType\DeliveryVariantStructure
     */
    public function setVariantType($variantType = null)
    {
        // validation for constraint: string
        if (!is_null($variantType) && !is_string($variantType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($variantType)), __LINE__);
        }
        $this->VariantType = $variantType;
        return $this;
    }
    /**
     * Get Content value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param \StructType\NaturalLanguageStringStructure $content
     * @return \StructType\DeliveryVariantStructure
     */
    public function setContent(\StructType\NaturalLanguageStringStructure $content = null)
    {
        $this->Content = $content;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryVariantStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
