<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DelaysStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for easement info.
 * @subpackage Structs
 */
class DelaysStructure extends AbstractStructBase
{
    /**
     * The DelayBand
     * Meta informations extracted from the WSDL
     * - documentation: Time band into which delay will fall.
     * - minOccurs: 0
     * @var string
     */
    public $DelayBand;
    /**
     * The DelayType
     * Meta informations extracted from the WSDL
     * - documentation: Category of delay.
     * - minOccurs: 0
     * @var string
     */
    public $DelayType;
    /**
     * The Delay
     * Meta informations extracted from the WSDL
     * - documentation: Additional journey time needed to overcome disruption. | Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used.
     * Milliseconds should not be used. Year should not be used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * - minOccurs: 0
     * @var string
     */
    public $Delay;
    /**
     * Constructor method for DelaysStructure
     * @uses DelaysStructure::setDelayBand()
     * @uses DelaysStructure::setDelayType()
     * @uses DelaysStructure::setDelay()
     * @param string $delayBand
     * @param string $delayType
     * @param string $delay
     */
    public function __construct($delayBand = null, $delayType = null, $delay = null)
    {
        $this
            ->setDelayBand($delayBand)
            ->setDelayType($delayType)
            ->setDelay($delay);
    }
    /**
     * Get DelayBand value
     * @return string|null
     */
    public function getDelayBand()
    {
        return $this->DelayBand;
    }
    /**
     * Set DelayBand value
     * @uses \EnumType\DelayBandEnumeration::valueIsValid()
     * @uses \EnumType\DelayBandEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delayBand
     * @return \StructType\DelaysStructure
     */
    public function setDelayBand($delayBand = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DelayBandEnumeration::valueIsValid($delayBand)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $delayBand, implode(', ', \EnumType\DelayBandEnumeration::getValidValues())), __LINE__);
        }
        $this->DelayBand = $delayBand;
        return $this;
    }
    /**
     * Get DelayType value
     * @return string|null
     */
    public function getDelayType()
    {
        return $this->DelayType;
    }
    /**
     * Set DelayType value
     * @uses \EnumType\DelaysTypeEnum::valueIsValid()
     * @uses \EnumType\DelaysTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delayType
     * @return \StructType\DelaysStructure
     */
    public function setDelayType($delayType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DelaysTypeEnum::valueIsValid($delayType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $delayType, implode(', ', \EnumType\DelaysTypeEnum::getValidValues())), __LINE__);
        }
        $this->DelayType = $delayType;
        return $this;
    }
    /**
     * Get Delay value
     * @return string|null
     */
    public function getDelay()
    {
        return $this->Delay;
    }
    /**
     * Set Delay value
     * @param string $delay
     * @return \StructType\DelaysStructure
     */
    public function setDelay($delay = null)
    {
        // validation for constraint: string
        if (!is_null($delay) && !is_string($delay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delay)), __LINE__);
        }
        $this->Delay = $delay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DelaysStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
