<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Delays StructType
 * @subpackage Structs
 */
class Delays extends AbstractStructBase
{
    /**
     * The delayBand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $delayBand;
    /**
     * The delaysType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $delaysType;
    /**
     * The delayTimeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $delayTimeValue;
    /**
     * The delaysExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $delaysExtension;
    /**
     * Constructor method for Delays
     * @uses Delays::setDelayBand()
     * @uses Delays::setDelaysType()
     * @uses Delays::setDelayTimeValue()
     * @uses Delays::setDelaysExtension()
     * @param string $delayBand
     * @param string $delaysType
     * @param float $delayTimeValue
     * @param \StructType\ExtensionType $delaysExtension
     */
    public function __construct($delayBand = null, $delaysType = null, $delayTimeValue = null, \StructType\ExtensionType $delaysExtension = null)
    {
        $this
            ->setDelayBand($delayBand)
            ->setDelaysType($delaysType)
            ->setDelayTimeValue($delayTimeValue)
            ->setDelaysExtension($delaysExtension);
    }
    /**
     * Get delayBand value
     * @return string|null
     */
    public function getDelayBand()
    {
        return $this->delayBand;
    }
    /**
     * Set delayBand value
     * @uses \EnumType\DelayBandEnum::valueIsValid()
     * @uses \EnumType\DelayBandEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delayBand
     * @return \StructType\Delays
     */
    public function setDelayBand($delayBand = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DelayBandEnum::valueIsValid($delayBand)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $delayBand, implode(', ', \EnumType\DelayBandEnum::getValidValues())), __LINE__);
        }
        $this->delayBand = $delayBand;
        return $this;
    }
    /**
     * Get delaysType value
     * @return string|null
     */
    public function getDelaysType()
    {
        return $this->delaysType;
    }
    /**
     * Set delaysType value
     * @uses \EnumType\DelaysTypeEnum::valueIsValid()
     * @uses \EnumType\DelaysTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delaysType
     * @return \StructType\Delays
     */
    public function setDelaysType($delaysType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DelaysTypeEnum::valueIsValid($delaysType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $delaysType, implode(', ', \EnumType\DelaysTypeEnum::getValidValues())), __LINE__);
        }
        $this->delaysType = $delaysType;
        return $this;
    }
    /**
     * Get delayTimeValue value
     * @return float|null
     */
    public function getDelayTimeValue()
    {
        return $this->delayTimeValue;
    }
    /**
     * Set delayTimeValue value
     * @param float $delayTimeValue
     * @return \StructType\Delays
     */
    public function setDelayTimeValue($delayTimeValue = null)
    {
        $this->delayTimeValue = $delayTimeValue;
        return $this;
    }
    /**
     * Get delaysExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getDelaysExtension()
    {
        return $this->delaysExtension;
    }
    /**
     * Set delaysExtension value
     * @param \StructType\ExtensionType $delaysExtension
     * @return \StructType\Delays
     */
    public function setDelaysExtension(\StructType\ExtensionType $delaysExtension = null)
    {
        $this->delaysExtension = $delaysExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Delays
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
