<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DefaultedTextStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a text that may be overridden.
 * @subpackage Structs
 */
class DefaultedTextStructure extends NaturalLanguageStringStructure
{
    /**
     * The _
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $_;
    /**
     * The overridden
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether the text value has been overridden from the generated default. Default is 'true'.
     * - use: optional
     * @var bool
     */
    public $overridden;
    /**
     * Constructor method for DefaultedTextStructure
     * @uses DefaultedTextStructure::set_()
     * @uses DefaultedTextStructure::setOverridden()
     * @param \StructType\NaturalLanguageStringStructure $_
     * @param bool $overridden
     */
    public function __construct(\StructType\NaturalLanguageStringStructure $_ = null, $overridden = true)
    {
        $this
            ->set_($_)
            ->setOverridden($overridden);
    }
    /**
     * Get _ value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\NaturalLanguageStringStructure $_
     * @return \StructType\DefaultedTextStructure
     */
    public function set_(\StructType\NaturalLanguageStringStructure $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get overridden value
     * @return bool|null
     */
    public function getOverridden()
    {
        return $this->overridden;
    }
    /**
     * Set overridden value
     * @param bool $overridden
     * @return \StructType\DefaultedTextStructure
     */
    public function setOverridden($overridden = true)
    {
        // validation for constraint: boolean
        if (!is_null($overridden) && !is_bool($overridden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overridden)), __LINE__);
        }
        $this->overridden = $overridden;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DefaultedTextStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
