<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedVehicleJourneyIndirectRefStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Origin and Destination stop of a VEHICLE JOURNEY.
 * @subpackage Structs
 */
class DatedVehicleJourneyIndirectRefStructure extends AbstractStructBase
{
    /**
     * The OriginRef
     * Meta informations extracted from the WSDL
     * - documentation: The origin is used to help identify the VEHICLE JOURNEY.
     * @var \StructType\StopPointRefStructure
     */
    public $OriginRef;
    /**
     * The AimedDepartureTime
     * Meta informations extracted from the WSDL
     * - documentation: Departure time from origin SCHEDULED STOP POINT.
     * @var string
     */
    public $AimedDepartureTime;
    /**
     * The DestinationRef
     * Meta informations extracted from the WSDL
     * - documentation: The destination is used to help identify the VEHICLE JOURNEY.
     * @var \StructType\StopPointRefStructure
     */
    public $DestinationRef;
    /**
     * The AimedArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: Arrival time at destination SCHEDULED STOP POINT.
     * @var string
     */
    public $AimedArrivalTime;
    /**
     * Constructor method for DatedVehicleJourneyIndirectRefStructure
     * @uses DatedVehicleJourneyIndirectRefStructure::setOriginRef()
     * @uses DatedVehicleJourneyIndirectRefStructure::setAimedDepartureTime()
     * @uses DatedVehicleJourneyIndirectRefStructure::setDestinationRef()
     * @uses DatedVehicleJourneyIndirectRefStructure::setAimedArrivalTime()
     * @param \StructType\StopPointRefStructure $originRef
     * @param string $aimedDepartureTime
     * @param \StructType\StopPointRefStructure $destinationRef
     * @param string $aimedArrivalTime
     */
    public function __construct(\StructType\StopPointRefStructure $originRef = null, $aimedDepartureTime = null, \StructType\StopPointRefStructure $destinationRef = null, $aimedArrivalTime = null)
    {
        $this
            ->setOriginRef($originRef)
            ->setAimedDepartureTime($aimedDepartureTime)
            ->setDestinationRef($destinationRef)
            ->setAimedArrivalTime($aimedArrivalTime);
    }
    /**
     * Get OriginRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getOriginRef()
    {
        return $this->OriginRef;
    }
    /**
     * Set OriginRef value
     * @param \StructType\StopPointRefStructure $originRef
     * @return \StructType\DatedVehicleJourneyIndirectRefStructure
     */
    public function setOriginRef(\StructType\StopPointRefStructure $originRef = null)
    {
        $this->OriginRef = $originRef;
        return $this;
    }
    /**
     * Get AimedDepartureTime value
     * @return string|null
     */
    public function getAimedDepartureTime()
    {
        return $this->AimedDepartureTime;
    }
    /**
     * Set AimedDepartureTime value
     * @param string $aimedDepartureTime
     * @return \StructType\DatedVehicleJourneyIndirectRefStructure
     */
    public function setAimedDepartureTime($aimedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedDepartureTime) && !is_string($aimedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedDepartureTime)), __LINE__);
        }
        $this->AimedDepartureTime = $aimedDepartureTime;
        return $this;
    }
    /**
     * Get DestinationRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getDestinationRef()
    {
        return $this->DestinationRef;
    }
    /**
     * Set DestinationRef value
     * @param \StructType\StopPointRefStructure $destinationRef
     * @return \StructType\DatedVehicleJourneyIndirectRefStructure
     */
    public function setDestinationRef(\StructType\StopPointRefStructure $destinationRef = null)
    {
        $this->DestinationRef = $destinationRef;
        return $this;
    }
    /**
     * Get AimedArrivalTime value
     * @return string|null
     */
    public function getAimedArrivalTime()
    {
        return $this->AimedArrivalTime;
    }
    /**
     * Set AimedArrivalTime value
     * @param string $aimedArrivalTime
     * @return \StructType\DatedVehicleJourneyIndirectRefStructure
     */
    public function setAimedArrivalTime($aimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedArrivalTime) && !is_string($aimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedArrivalTime)), __LINE__);
        }
        $this->AimedArrivalTime = $aimedArrivalTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatedVehicleJourneyIndirectRefStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
