<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedTimetableVersionFrameStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Production Timetable of a LINE.
 * @subpackage Structs
 */
class DatedTimetableVersionFrameStructure extends AbstractItemStructure
{
    /**
     * The VersionRef
     * Meta informations extracted from the WSDL
     * - documentation: Timetable Version.
     * - minOccurs: 0
     * @var \StructType\VersionRefStructure
     */
    public $VersionRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The JourneyPatternRef
     * @var \StructType\JourneyPatternRefStructure
     */
    public $JourneyPatternRef;
    /**
     * The JourneyPatternName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $JourneyPatternName;
    /**
     * The VehicleMode
     * @var string
     */
    public $VehicleMode;
    /**
     * The RouteRef
     * @var \StructType\RouteRefStructure
     */
    public $RouteRef;
    /**
     * The PublishedLineName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $PublishedLineName;
    /**
     * The GroupOfLinesRef
     * @var \StructType\GroupOfLinesRefStructure
     */
    public $GroupOfLinesRef;
    /**
     * The DirectionName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DirectionName;
    /**
     * The ExternalLineRef
     * @var \StructType\LineRefStructure
     */
    public $ExternalLineRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The ProductCategoryRef
     * @var \StructType\ProductCategoryRefStructure
     */
    public $ProductCategoryRef;
    /**
     * The ServiceFeatureRef
     * @var \StructType\ServiceFeatureRefStructure
     */
    public $ServiceFeatureRef;
    /**
     * The VehicleFeatureRef
     * @var \StructType\VehicleFeatureRefStructure
     */
    public $VehicleFeatureRef;
    /**
     * The OriginDisplay
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $OriginDisplay;
    /**
     * The DestinationDisplay
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DestinationDisplay;
    /**
     * The LineNote
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $LineNote;
    /**
     * The FirstOrLastJourney
     * @var string
     */
    public $FirstOrLastJourney;
    /**
     * The HeadwayService
     * @var bool
     */
    public $HeadwayService;
    /**
     * The Monitored
     * @var bool
     */
    public $Monitored;
    /**
     * The DatedVehicleJourney
     * Meta informations extracted from the WSDL
     * - documentation: Complete list of all planned VEHICLE JOURNEYs for this LINE and DIRECTION.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedVehicleJourneyStructure[]
     */
    public $DatedVehicleJourney;
    /**
     * The ServiceJourneyInterchange
     * Meta informations extracted from the WSDL
     * - documentation: Connection paramters for a SERVICE JOURNEY INTERCHANGE between a feeder and distributor journey. SIRI 2.0
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceJourneyInterchangeStructure[]
     */
    public $ServiceJourneyInterchange;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for DatedTimetableVersionFrameStructure
     * @uses DatedTimetableVersionFrameStructure::setVersionRef()
     * @uses DatedTimetableVersionFrameStructure::setLineRef()
     * @uses DatedTimetableVersionFrameStructure::setDirectionRef()
     * @uses DatedTimetableVersionFrameStructure::setJourneyPatternRef()
     * @uses DatedTimetableVersionFrameStructure::setJourneyPatternName()
     * @uses DatedTimetableVersionFrameStructure::setVehicleMode()
     * @uses DatedTimetableVersionFrameStructure::setRouteRef()
     * @uses DatedTimetableVersionFrameStructure::setPublishedLineName()
     * @uses DatedTimetableVersionFrameStructure::setGroupOfLinesRef()
     * @uses DatedTimetableVersionFrameStructure::setDirectionName()
     * @uses DatedTimetableVersionFrameStructure::setExternalLineRef()
     * @uses DatedTimetableVersionFrameStructure::setOperatorRef()
     * @uses DatedTimetableVersionFrameStructure::setProductCategoryRef()
     * @uses DatedTimetableVersionFrameStructure::setServiceFeatureRef()
     * @uses DatedTimetableVersionFrameStructure::setVehicleFeatureRef()
     * @uses DatedTimetableVersionFrameStructure::setOriginDisplay()
     * @uses DatedTimetableVersionFrameStructure::setDestinationDisplay()
     * @uses DatedTimetableVersionFrameStructure::setLineNote()
     * @uses DatedTimetableVersionFrameStructure::setFirstOrLastJourney()
     * @uses DatedTimetableVersionFrameStructure::setHeadwayService()
     * @uses DatedTimetableVersionFrameStructure::setMonitored()
     * @uses DatedTimetableVersionFrameStructure::setDatedVehicleJourney()
     * @uses DatedTimetableVersionFrameStructure::setServiceJourneyInterchange()
     * @uses DatedTimetableVersionFrameStructure::setExtensions()
     * @param \StructType\VersionRefStructure $versionRef
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @param \StructType\NaturalLanguageStringStructure $journeyPatternName
     * @param string $vehicleMode
     * @param \StructType\RouteRefStructure $routeRef
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @param \StructType\GroupOfLinesRefStructure $groupOfLinesRef
     * @param \StructType\NaturalLanguageStringStructure $directionName
     * @param \StructType\LineRefStructure $externalLineRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @param \StructType\NaturalLanguageStringStructure $originDisplay
     * @param \StructType\NaturalLanguageStringStructure $destinationDisplay
     * @param \StructType\NaturalLanguagePlaceNameStructure $lineNote
     * @param string $firstOrLastJourney
     * @param bool $headwayService
     * @param bool $monitored
     * @param \StructType\DatedVehicleJourneyStructure[] $datedVehicleJourney
     * @param \StructType\ServiceJourneyInterchangeStructure[] $serviceJourneyInterchange
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\VersionRefStructure $versionRef = null, \StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, \StructType\JourneyPatternRefStructure $journeyPatternRef = null, \StructType\NaturalLanguageStringStructure $journeyPatternName = null, $vehicleMode = null, \StructType\RouteRefStructure $routeRef = null, \StructType\NaturalLanguageStringStructure $publishedLineName = null, \StructType\GroupOfLinesRefStructure $groupOfLinesRef = null, \StructType\NaturalLanguageStringStructure $directionName = null, \StructType\LineRefStructure $externalLineRef = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\ProductCategoryRefStructure $productCategoryRef = null, \StructType\ServiceFeatureRefStructure $serviceFeatureRef = null, \StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null, \StructType\NaturalLanguageStringStructure $originDisplay = null, \StructType\NaturalLanguageStringStructure $destinationDisplay = null, \StructType\NaturalLanguagePlaceNameStructure $lineNote = null, $firstOrLastJourney = null, $headwayService = null, $monitored = null, array $datedVehicleJourney = array(), array $serviceJourneyInterchange = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setVersionRef($versionRef)
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setJourneyPatternRef($journeyPatternRef)
            ->setJourneyPatternName($journeyPatternName)
            ->setVehicleMode($vehicleMode)
            ->setRouteRef($routeRef)
            ->setPublishedLineName($publishedLineName)
            ->setGroupOfLinesRef($groupOfLinesRef)
            ->setDirectionName($directionName)
            ->setExternalLineRef($externalLineRef)
            ->setOperatorRef($operatorRef)
            ->setProductCategoryRef($productCategoryRef)
            ->setServiceFeatureRef($serviceFeatureRef)
            ->setVehicleFeatureRef($vehicleFeatureRef)
            ->setOriginDisplay($originDisplay)
            ->setDestinationDisplay($destinationDisplay)
            ->setLineNote($lineNote)
            ->setFirstOrLastJourney($firstOrLastJourney)
            ->setHeadwayService($headwayService)
            ->setMonitored($monitored)
            ->setDatedVehicleJourney($datedVehicleJourney)
            ->setServiceJourneyInterchange($serviceJourneyInterchange)
            ->setExtensions($extensions);
    }
    /**
     * Get VersionRef value
     * @return \StructType\VersionRefStructure|null
     */
    public function getVersionRef()
    {
        return $this->VersionRef;
    }
    /**
     * Set VersionRef value
     * @param \StructType\VersionRefStructure $versionRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setVersionRef(\StructType\VersionRefStructure $versionRef = null)
    {
        $this->VersionRef = $versionRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get JourneyPatternRef value
     * @return \StructType\JourneyPatternRefStructure|null
     */
    public function getJourneyPatternRef()
    {
        return $this->JourneyPatternRef;
    }
    /**
     * Set JourneyPatternRef value
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setJourneyPatternRef(\StructType\JourneyPatternRefStructure $journeyPatternRef = null)
    {
        $this->JourneyPatternRef = $journeyPatternRef;
        return $this;
    }
    /**
     * Get JourneyPatternName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getJourneyPatternName()
    {
        return $this->JourneyPatternName;
    }
    /**
     * Set JourneyPatternName value
     * @param \StructType\NaturalLanguageStringStructure $journeyPatternName
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setJourneyPatternName(\StructType\NaturalLanguageStringStructure $journeyPatternName = null)
    {
        $this->JourneyPatternName = $journeyPatternName;
        return $this;
    }
    /**
     * Get VehicleMode value
     * @return string|null
     */
    public function getVehicleMode()
    {
        return $this->VehicleMode;
    }
    /**
     * Set VehicleMode value
     * @uses \EnumType\VehicleModesEnumeration::valueIsValid()
     * @uses \EnumType\VehicleModesEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleMode
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setVehicleMode($vehicleMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleModesEnumeration::valueIsValid($vehicleMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleMode, implode(', ', \EnumType\VehicleModesEnumeration::getValidValues())), __LINE__);
        }
        $this->VehicleMode = $vehicleMode;
        return $this;
    }
    /**
     * Get RouteRef value
     * @return \StructType\RouteRefStructure|null
     */
    public function getRouteRef()
    {
        return $this->RouteRef;
    }
    /**
     * Set RouteRef value
     * @param \StructType\RouteRefStructure $routeRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setRouteRef(\StructType\RouteRefStructure $routeRef = null)
    {
        $this->RouteRef = $routeRef;
        return $this;
    }
    /**
     * Get PublishedLineName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getPublishedLineName()
    {
        return $this->PublishedLineName;
    }
    /**
     * Set PublishedLineName value
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setPublishedLineName(\StructType\NaturalLanguageStringStructure $publishedLineName = null)
    {
        $this->PublishedLineName = $publishedLineName;
        return $this;
    }
    /**
     * Get GroupOfLinesRef value
     * @return \StructType\GroupOfLinesRefStructure|null
     */
    public function getGroupOfLinesRef()
    {
        return $this->GroupOfLinesRef;
    }
    /**
     * Set GroupOfLinesRef value
     * @param \StructType\GroupOfLinesRefStructure $groupOfLinesRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setGroupOfLinesRef(\StructType\GroupOfLinesRefStructure $groupOfLinesRef = null)
    {
        $this->GroupOfLinesRef = $groupOfLinesRef;
        return $this;
    }
    /**
     * Get DirectionName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDirectionName()
    {
        return $this->DirectionName;
    }
    /**
     * Set DirectionName value
     * @param \StructType\NaturalLanguageStringStructure $directionName
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setDirectionName(\StructType\NaturalLanguageStringStructure $directionName = null)
    {
        $this->DirectionName = $directionName;
        return $this;
    }
    /**
     * Get ExternalLineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getExternalLineRef()
    {
        return $this->ExternalLineRef;
    }
    /**
     * Set ExternalLineRef value
     * @param \StructType\LineRefStructure $externalLineRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setExternalLineRef(\StructType\LineRefStructure $externalLineRef = null)
    {
        $this->ExternalLineRef = $externalLineRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get ProductCategoryRef value
     * @return \StructType\ProductCategoryRefStructure|null
     */
    public function getProductCategoryRef()
    {
        return $this->ProductCategoryRef;
    }
    /**
     * Set ProductCategoryRef value
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setProductCategoryRef(\StructType\ProductCategoryRefStructure $productCategoryRef = null)
    {
        $this->ProductCategoryRef = $productCategoryRef;
        return $this;
    }
    /**
     * Get ServiceFeatureRef value
     * @return \StructType\ServiceFeatureRefStructure|null
     */
    public function getServiceFeatureRef()
    {
        return $this->ServiceFeatureRef;
    }
    /**
     * Set ServiceFeatureRef value
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setServiceFeatureRef(\StructType\ServiceFeatureRefStructure $serviceFeatureRef = null)
    {
        $this->ServiceFeatureRef = $serviceFeatureRef;
        return $this;
    }
    /**
     * Get VehicleFeatureRef value
     * @return \StructType\VehicleFeatureRefStructure|null
     */
    public function getVehicleFeatureRef()
    {
        return $this->VehicleFeatureRef;
    }
    /**
     * Set VehicleFeatureRef value
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setVehicleFeatureRef(\StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null)
    {
        $this->VehicleFeatureRef = $vehicleFeatureRef;
        return $this;
    }
    /**
     * Get OriginDisplay value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getOriginDisplay()
    {
        return $this->OriginDisplay;
    }
    /**
     * Set OriginDisplay value
     * @param \StructType\NaturalLanguageStringStructure $originDisplay
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setOriginDisplay(\StructType\NaturalLanguageStringStructure $originDisplay = null)
    {
        $this->OriginDisplay = $originDisplay;
        return $this;
    }
    /**
     * Get DestinationDisplay value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDestinationDisplay()
    {
        return $this->DestinationDisplay;
    }
    /**
     * Set DestinationDisplay value
     * @param \StructType\NaturalLanguageStringStructure $destinationDisplay
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setDestinationDisplay(\StructType\NaturalLanguageStringStructure $destinationDisplay = null)
    {
        $this->DestinationDisplay = $destinationDisplay;
        return $this;
    }
    /**
     * Get LineNote value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getLineNote()
    {
        return $this->LineNote;
    }
    /**
     * Set LineNote value
     * @param \StructType\NaturalLanguagePlaceNameStructure $lineNote
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setLineNote(\StructType\NaturalLanguagePlaceNameStructure $lineNote = null)
    {
        $this->LineNote = $lineNote;
        return $this;
    }
    /**
     * Get FirstOrLastJourney value
     * @return string|null
     */
    public function getFirstOrLastJourney()
    {
        return $this->FirstOrLastJourney;
    }
    /**
     * Set FirstOrLastJourney value
     * @uses \EnumType\FirstOrLastJourneyEnumeration::valueIsValid()
     * @uses \EnumType\FirstOrLastJourneyEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firstOrLastJourney
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setFirstOrLastJourney($firstOrLastJourney = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FirstOrLastJourneyEnumeration::valueIsValid($firstOrLastJourney)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $firstOrLastJourney, implode(', ', \EnumType\FirstOrLastJourneyEnumeration::getValidValues())), __LINE__);
        }
        $this->FirstOrLastJourney = $firstOrLastJourney;
        return $this;
    }
    /**
     * Get HeadwayService value
     * @return bool|null
     */
    public function getHeadwayService()
    {
        return $this->HeadwayService;
    }
    /**
     * Set HeadwayService value
     * @param bool $headwayService
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setHeadwayService($headwayService = null)
    {
        // validation for constraint: boolean
        if (!is_null($headwayService) && !is_bool($headwayService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($headwayService)), __LINE__);
        }
        $this->HeadwayService = $headwayService;
        return $this;
    }
    /**
     * Get Monitored value
     * @return bool|null
     */
    public function getMonitored()
    {
        return $this->Monitored;
    }
    /**
     * Set Monitored value
     * @param bool $monitored
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setMonitored($monitored = null)
    {
        // validation for constraint: boolean
        if (!is_null($monitored) && !is_bool($monitored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($monitored)), __LINE__);
        }
        $this->Monitored = $monitored;
        return $this;
    }
    /**
     * Get DatedVehicleJourney value
     * @return \StructType\DatedVehicleJourneyStructure[]|null
     */
    public function getDatedVehicleJourney()
    {
        return $this->DatedVehicleJourney;
    }
    /**
     * Set DatedVehicleJourney value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedVehicleJourneyStructure[] $datedVehicleJourney
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setDatedVehicleJourney(array $datedVehicleJourney = array())
    {
        foreach ($datedVehicleJourney as $datedTimetableVersionFrameStructureDatedVehicleJourneyItem) {
            // validation for constraint: itemType
            if (!$datedTimetableVersionFrameStructureDatedVehicleJourneyItem instanceof \StructType\DatedVehicleJourneyStructure) {
                throw new \InvalidArgumentException(sprintf('The DatedVehicleJourney property can only contain items of \StructType\DatedVehicleJourneyStructure, "%s" given', is_object($datedTimetableVersionFrameStructureDatedVehicleJourneyItem) ? get_class($datedTimetableVersionFrameStructureDatedVehicleJourneyItem) : gettype($datedTimetableVersionFrameStructureDatedVehicleJourneyItem)), __LINE__);
            }
        }
        $this->DatedVehicleJourney = $datedVehicleJourney;
        return $this;
    }
    /**
     * Add item to DatedVehicleJourney value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedVehicleJourneyStructure $item
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function addToDatedVehicleJourney(\StructType\DatedVehicleJourneyStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedVehicleJourneyStructure) {
            throw new \InvalidArgumentException(sprintf('The DatedVehicleJourney property can only contain items of \StructType\DatedVehicleJourneyStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DatedVehicleJourney[] = $item;
        return $this;
    }
    /**
     * Get ServiceJourneyInterchange value
     * @return \StructType\ServiceJourneyInterchangeStructure[]|null
     */
    public function getServiceJourneyInterchange()
    {
        return $this->ServiceJourneyInterchange;
    }
    /**
     * Set ServiceJourneyInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceJourneyInterchangeStructure[] $serviceJourneyInterchange
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setServiceJourneyInterchange(array $serviceJourneyInterchange = array())
    {
        foreach ($serviceJourneyInterchange as $datedTimetableVersionFrameStructureServiceJourneyInterchangeItem) {
            // validation for constraint: itemType
            if (!$datedTimetableVersionFrameStructureServiceJourneyInterchangeItem instanceof \StructType\ServiceJourneyInterchangeStructure) {
                throw new \InvalidArgumentException(sprintf('The ServiceJourneyInterchange property can only contain items of \StructType\ServiceJourneyInterchangeStructure, "%s" given', is_object($datedTimetableVersionFrameStructureServiceJourneyInterchangeItem) ? get_class($datedTimetableVersionFrameStructureServiceJourneyInterchangeItem) : gettype($datedTimetableVersionFrameStructureServiceJourneyInterchangeItem)), __LINE__);
            }
        }
        $this->ServiceJourneyInterchange = $serviceJourneyInterchange;
        return $this;
    }
    /**
     * Add item to ServiceJourneyInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceJourneyInterchangeStructure $item
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function addToServiceJourneyInterchange(\StructType\ServiceJourneyInterchangeStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceJourneyInterchangeStructure) {
            throw new \InvalidArgumentException(sprintf('The ServiceJourneyInterchange property can only contain items of \StructType\ServiceJourneyInterchangeStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceJourneyInterchange[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatedTimetableVersionFrameStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
