<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedCalls StructType
 * Meta informations extracted from the WSDL
 * - documentation: Complete sequence of stops along the route path, in calling order.
 * @subpackage Structs
 */
class DatedCalls extends AbstractStructBase
{
    /**
     * The DatedCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * - ref: DatedCall
     * @var \StructType\DatedCallStructure[]
     */
    public $DatedCall;
    /**
     * Constructor method for DatedCalls
     * @uses DatedCalls::setDatedCall()
     * @param \StructType\DatedCallStructure[] $datedCall
     */
    public function __construct(array $datedCall = array())
    {
        $this
            ->setDatedCall($datedCall);
    }
    /**
     * Get DatedCall value
     * @return \StructType\DatedCallStructure[]
     */
    public function getDatedCall()
    {
        return $this->DatedCall;
    }
    /**
     * Set DatedCall value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedCallStructure[] $datedCall
     * @return \StructType\DatedCalls
     */
    public function setDatedCall(array $datedCall = array())
    {
        foreach ($datedCall as $datedCallsDatedCallItem) {
            // validation for constraint: itemType
            if (!$datedCallsDatedCallItem instanceof \StructType\DatedCallStructure) {
                throw new \InvalidArgumentException(sprintf('The DatedCall property can only contain items of \StructType\DatedCallStructure, "%s" given', is_object($datedCallsDatedCallItem) ? get_class($datedCallsDatedCallItem) : gettype($datedCallsDatedCallItem)), __LINE__);
            }
        }
        $this->DatedCall = $datedCall;
        return $this;
    }
    /**
     * Add item to DatedCall value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedCallStructure $item
     * @return \StructType\DatedCalls
     */
    public function addToDatedCall(\StructType\DatedCallStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedCallStructure) {
            throw new \InvalidArgumentException(sprintf('The DatedCall property can only contain items of \StructType\DatedCallStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DatedCall[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatedCalls
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
