<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedCallStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Planned VEHICLE JOURNEY Stop (Production Timetable Service).
 * @subpackage Structs
 */
class DatedCallStructure extends AbstractStructBase
{
    /**
     * The StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The VisitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Type for Stop Visit.
     * @var int
     */
    public $VisitNumber;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The StopPointName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $StopPointName;
    /**
     * The TimingPoint
     * @var bool
     */
    public $TimingPoint;
    /**
     * The BoardingStretch
     * @var bool
     */
    public $BoardingStretch;
    /**
     * The RequestStop
     * @var bool
     */
    public $RequestStop;
    /**
     * The OriginDisplay
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $OriginDisplay;
    /**
     * The DestinationDisplay
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DestinationDisplay;
    /**
     * The CallNote
     * Meta informations extracted from the WSDL
     * - documentation: Text annotation that applies to this call.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $CallNote;
    /**
     * The AimedArrivalTime
     * @var string
     */
    public $AimedArrivalTime;
    /**
     * The ArrivalPlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ArrivalPlatformName;
    /**
     * The ArrivalBoardingActivity
     * @var string
     */
    public $ArrivalBoardingActivity;
    /**
     * The ArrivalStopAssignment
     * @var \StructType\PlannedStopAssignmentStructure
     */
    public $ArrivalStopAssignment;
    /**
     * The ArrivalOperatorRefs
     * @var \StructType\OperatorRefStructure
     */
    public $ArrivalOperatorRefs;
    /**
     * The AimedDepartureTime
     * @var string
     */
    public $AimedDepartureTime;
    /**
     * The DeparturePlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DeparturePlatformName;
    /**
     * The DepartureBoardingActivity
     * @var string
     */
    public $DepartureBoardingActivity;
    /**
     * The DepartureStopAssignment
     * @var \StructType\PlannedStopAssignmentStructure
     */
    public $DepartureStopAssignment;
    /**
     * The DepartureOperatorRefs
     * @var \StructType\OperatorRefStructure
     */
    public $DepartureOperatorRefs;
    /**
     * The AimedLatestPassengerAccessTime
     * @var string
     */
    public $AimedLatestPassengerAccessTime;
    /**
     * The AimedHeadwayInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $AimedHeadwayInterval;
    /**
     * The TargetedInterchange
     * Meta informations extracted from the WSDL
     * - documentation: Information on any planned distributor connections (deprecated from SIRI V2.0 ... see 2 next attributes)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TargetedInterchangeStructure[]
     */
    public $TargetedInterchange;
    /**
     * The FromServiceJourneyInterchange
     * Meta informations extracted from the WSDL
     * - documentation: Information on any planned feeder connections. SIRI 2.0
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FromServiceJourneyInterchangeStructure[]
     */
    public $FromServiceJourneyInterchange;
    /**
     * The ToServiceJourneyInterchange
     * Meta informations extracted from the WSDL
     * - documentation: Information on any planned distributor connections. SIRI 2.0
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ToServiceJourneyInterchangeStructure[]
     */
    public $ToServiceJourneyInterchange;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for DatedCallStructure
     * @uses DatedCallStructure::setStopPointRef()
     * @uses DatedCallStructure::setVisitNumber()
     * @uses DatedCallStructure::setOrder()
     * @uses DatedCallStructure::setStopPointName()
     * @uses DatedCallStructure::setTimingPoint()
     * @uses DatedCallStructure::setBoardingStretch()
     * @uses DatedCallStructure::setRequestStop()
     * @uses DatedCallStructure::setOriginDisplay()
     * @uses DatedCallStructure::setDestinationDisplay()
     * @uses DatedCallStructure::setCallNote()
     * @uses DatedCallStructure::setAimedArrivalTime()
     * @uses DatedCallStructure::setArrivalPlatformName()
     * @uses DatedCallStructure::setArrivalBoardingActivity()
     * @uses DatedCallStructure::setArrivalStopAssignment()
     * @uses DatedCallStructure::setArrivalOperatorRefs()
     * @uses DatedCallStructure::setAimedDepartureTime()
     * @uses DatedCallStructure::setDeparturePlatformName()
     * @uses DatedCallStructure::setDepartureBoardingActivity()
     * @uses DatedCallStructure::setDepartureStopAssignment()
     * @uses DatedCallStructure::setDepartureOperatorRefs()
     * @uses DatedCallStructure::setAimedLatestPassengerAccessTime()
     * @uses DatedCallStructure::setAimedHeadwayInterval()
     * @uses DatedCallStructure::setTargetedInterchange()
     * @uses DatedCallStructure::setFromServiceJourneyInterchange()
     * @uses DatedCallStructure::setToServiceJourneyInterchange()
     * @uses DatedCallStructure::setExtensions()
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param int $visitNumber
     * @param int $order
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     * @param bool $timingPoint
     * @param bool $boardingStretch
     * @param bool $requestStop
     * @param \StructType\NaturalLanguageStringStructure $originDisplay
     * @param \StructType\NaturalLanguageStringStructure $destinationDisplay
     * @param \StructType\NaturalLanguageStringStructure[] $callNote
     * @param string $aimedArrivalTime
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @param string $arrivalBoardingActivity
     * @param \StructType\PlannedStopAssignmentStructure $arrivalStopAssignment
     * @param \StructType\OperatorRefStructure $arrivalOperatorRefs
     * @param string $aimedDepartureTime
     * @param \StructType\NaturalLanguageStringStructure $departurePlatformName
     * @param string $departureBoardingActivity
     * @param \StructType\PlannedStopAssignmentStructure $departureStopAssignment
     * @param \StructType\OperatorRefStructure $departureOperatorRefs
     * @param string $aimedLatestPassengerAccessTime
     * @param string $aimedHeadwayInterval
     * @param \StructType\TargetedInterchangeStructure[] $targetedInterchange
     * @param \StructType\FromServiceJourneyInterchangeStructure[] $fromServiceJourneyInterchange
     * @param \StructType\ToServiceJourneyInterchangeStructure[] $toServiceJourneyInterchange
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\StopPointRefStructure $stopPointRef = null, $visitNumber = null, $order = null, \StructType\NaturalLanguageStringStructure $stopPointName = null, $timingPoint = null, $boardingStretch = null, $requestStop = null, \StructType\NaturalLanguageStringStructure $originDisplay = null, \StructType\NaturalLanguageStringStructure $destinationDisplay = null, array $callNote = array(), $aimedArrivalTime = null, \StructType\NaturalLanguageStringStructure $arrivalPlatformName = null, $arrivalBoardingActivity = null, \StructType\PlannedStopAssignmentStructure $arrivalStopAssignment = null, \StructType\OperatorRefStructure $arrivalOperatorRefs = null, $aimedDepartureTime = null, \StructType\NaturalLanguageStringStructure $departurePlatformName = null, $departureBoardingActivity = null, \StructType\PlannedStopAssignmentStructure $departureStopAssignment = null, \StructType\OperatorRefStructure $departureOperatorRefs = null, $aimedLatestPassengerAccessTime = null, $aimedHeadwayInterval = null, array $targetedInterchange = array(), array $fromServiceJourneyInterchange = array(), array $toServiceJourneyInterchange = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setStopPointRef($stopPointRef)
            ->setVisitNumber($visitNumber)
            ->setOrder($order)
            ->setStopPointName($stopPointName)
            ->setTimingPoint($timingPoint)
            ->setBoardingStretch($boardingStretch)
            ->setRequestStop($requestStop)
            ->setOriginDisplay($originDisplay)
            ->setDestinationDisplay($destinationDisplay)
            ->setCallNote($callNote)
            ->setAimedArrivalTime($aimedArrivalTime)
            ->setArrivalPlatformName($arrivalPlatformName)
            ->setArrivalBoardingActivity($arrivalBoardingActivity)
            ->setArrivalStopAssignment($arrivalStopAssignment)
            ->setArrivalOperatorRefs($arrivalOperatorRefs)
            ->setAimedDepartureTime($aimedDepartureTime)
            ->setDeparturePlatformName($departurePlatformName)
            ->setDepartureBoardingActivity($departureBoardingActivity)
            ->setDepartureStopAssignment($departureStopAssignment)
            ->setDepartureOperatorRefs($departureOperatorRefs)
            ->setAimedLatestPassengerAccessTime($aimedLatestPassengerAccessTime)
            ->setAimedHeadwayInterval($aimedHeadwayInterval)
            ->setTargetedInterchange($targetedInterchange)
            ->setFromServiceJourneyInterchange($fromServiceJourneyInterchange)
            ->setToServiceJourneyInterchange($toServiceJourneyInterchange)
            ->setExtensions($extensions);
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\DatedCallStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get VisitNumber value
     * @return int|null
     */
    public function getVisitNumber()
    {
        return $this->VisitNumber;
    }
    /**
     * Set VisitNumber value
     * @param int $visitNumber
     * @return \StructType\DatedCallStructure
     */
    public function setVisitNumber($visitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($visitNumber) && !is_numeric($visitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($visitNumber)), __LINE__);
        }
        $this->VisitNumber = $visitNumber;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\DatedCallStructure
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get StopPointName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getStopPointName()
    {
        return $this->StopPointName;
    }
    /**
     * Set StopPointName value
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     * @return \StructType\DatedCallStructure
     */
    public function setStopPointName(\StructType\NaturalLanguageStringStructure $stopPointName = null)
    {
        $this->StopPointName = $stopPointName;
        return $this;
    }
    /**
     * Get TimingPoint value
     * @return bool|null
     */
    public function getTimingPoint()
    {
        return $this->TimingPoint;
    }
    /**
     * Set TimingPoint value
     * @param bool $timingPoint
     * @return \StructType\DatedCallStructure
     */
    public function setTimingPoint($timingPoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($timingPoint) && !is_bool($timingPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($timingPoint)), __LINE__);
        }
        $this->TimingPoint = $timingPoint;
        return $this;
    }
    /**
     * Get BoardingStretch value
     * @return bool|null
     */
    public function getBoardingStretch()
    {
        return $this->BoardingStretch;
    }
    /**
     * Set BoardingStretch value
     * @param bool $boardingStretch
     * @return \StructType\DatedCallStructure
     */
    public function setBoardingStretch($boardingStretch = null)
    {
        // validation for constraint: boolean
        if (!is_null($boardingStretch) && !is_bool($boardingStretch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($boardingStretch)), __LINE__);
        }
        $this->BoardingStretch = $boardingStretch;
        return $this;
    }
    /**
     * Get RequestStop value
     * @return bool|null
     */
    public function getRequestStop()
    {
        return $this->RequestStop;
    }
    /**
     * Set RequestStop value
     * @param bool $requestStop
     * @return \StructType\DatedCallStructure
     */
    public function setRequestStop($requestStop = null)
    {
        // validation for constraint: boolean
        if (!is_null($requestStop) && !is_bool($requestStop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requestStop)), __LINE__);
        }
        $this->RequestStop = $requestStop;
        return $this;
    }
    /**
     * Get OriginDisplay value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getOriginDisplay()
    {
        return $this->OriginDisplay;
    }
    /**
     * Set OriginDisplay value
     * @param \StructType\NaturalLanguageStringStructure $originDisplay
     * @return \StructType\DatedCallStructure
     */
    public function setOriginDisplay(\StructType\NaturalLanguageStringStructure $originDisplay = null)
    {
        $this->OriginDisplay = $originDisplay;
        return $this;
    }
    /**
     * Get DestinationDisplay value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDestinationDisplay()
    {
        return $this->DestinationDisplay;
    }
    /**
     * Set DestinationDisplay value
     * @param \StructType\NaturalLanguageStringStructure $destinationDisplay
     * @return \StructType\DatedCallStructure
     */
    public function setDestinationDisplay(\StructType\NaturalLanguageStringStructure $destinationDisplay = null)
    {
        $this->DestinationDisplay = $destinationDisplay;
        return $this;
    }
    /**
     * Get CallNote value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getCallNote()
    {
        return $this->CallNote;
    }
    /**
     * Set CallNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $callNote
     * @return \StructType\DatedCallStructure
     */
    public function setCallNote(array $callNote = array())
    {
        foreach ($callNote as $datedCallStructureCallNoteItem) {
            // validation for constraint: itemType
            if (!$datedCallStructureCallNoteItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The CallNote property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($datedCallStructureCallNoteItem) ? get_class($datedCallStructureCallNoteItem) : gettype($datedCallStructureCallNoteItem)), __LINE__);
            }
        }
        $this->CallNote = $callNote;
        return $this;
    }
    /**
     * Add item to CallNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\DatedCallStructure
     */
    public function addToCallNote(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The CallNote property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CallNote[] = $item;
        return $this;
    }
    /**
     * Get AimedArrivalTime value
     * @return string|null
     */
    public function getAimedArrivalTime()
    {
        return $this->AimedArrivalTime;
    }
    /**
     * Set AimedArrivalTime value
     * @param string $aimedArrivalTime
     * @return \StructType\DatedCallStructure
     */
    public function setAimedArrivalTime($aimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedArrivalTime) && !is_string($aimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedArrivalTime)), __LINE__);
        }
        $this->AimedArrivalTime = $aimedArrivalTime;
        return $this;
    }
    /**
     * Get ArrivalPlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getArrivalPlatformName()
    {
        return $this->ArrivalPlatformName;
    }
    /**
     * Set ArrivalPlatformName value
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @return \StructType\DatedCallStructure
     */
    public function setArrivalPlatformName(\StructType\NaturalLanguageStringStructure $arrivalPlatformName = null)
    {
        $this->ArrivalPlatformName = $arrivalPlatformName;
        return $this;
    }
    /**
     * Get ArrivalBoardingActivity value
     * @return string|null
     */
    public function getArrivalBoardingActivity()
    {
        return $this->ArrivalBoardingActivity;
    }
    /**
     * Set ArrivalBoardingActivity value
     * @uses \EnumType\ArrivalBoardingActivityEnumeration::valueIsValid()
     * @uses \EnumType\ArrivalBoardingActivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalBoardingActivity
     * @return \StructType\DatedCallStructure
     */
    public function setArrivalBoardingActivity($arrivalBoardingActivity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ArrivalBoardingActivityEnumeration::valueIsValid($arrivalBoardingActivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arrivalBoardingActivity, implode(', ', \EnumType\ArrivalBoardingActivityEnumeration::getValidValues())), __LINE__);
        }
        $this->ArrivalBoardingActivity = $arrivalBoardingActivity;
        return $this;
    }
    /**
     * Get ArrivalStopAssignment value
     * @return \StructType\PlannedStopAssignmentStructure|null
     */
    public function getArrivalStopAssignment()
    {
        return $this->ArrivalStopAssignment;
    }
    /**
     * Set ArrivalStopAssignment value
     * @param \StructType\PlannedStopAssignmentStructure $arrivalStopAssignment
     * @return \StructType\DatedCallStructure
     */
    public function setArrivalStopAssignment(\StructType\PlannedStopAssignmentStructure $arrivalStopAssignment = null)
    {
        $this->ArrivalStopAssignment = $arrivalStopAssignment;
        return $this;
    }
    /**
     * Get ArrivalOperatorRefs value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getArrivalOperatorRefs()
    {
        return $this->ArrivalOperatorRefs;
    }
    /**
     * Set ArrivalOperatorRefs value
     * @param \StructType\OperatorRefStructure $arrivalOperatorRefs
     * @return \StructType\DatedCallStructure
     */
    public function setArrivalOperatorRefs(\StructType\OperatorRefStructure $arrivalOperatorRefs = null)
    {
        $this->ArrivalOperatorRefs = $arrivalOperatorRefs;
        return $this;
    }
    /**
     * Get AimedDepartureTime value
     * @return string|null
     */
    public function getAimedDepartureTime()
    {
        return $this->AimedDepartureTime;
    }
    /**
     * Set AimedDepartureTime value
     * @param string $aimedDepartureTime
     * @return \StructType\DatedCallStructure
     */
    public function setAimedDepartureTime($aimedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedDepartureTime) && !is_string($aimedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedDepartureTime)), __LINE__);
        }
        $this->AimedDepartureTime = $aimedDepartureTime;
        return $this;
    }
    /**
     * Get DeparturePlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDeparturePlatformName()
    {
        return $this->DeparturePlatformName;
    }
    /**
     * Set DeparturePlatformName value
     * @param \StructType\NaturalLanguageStringStructure $departurePlatformName
     * @return \StructType\DatedCallStructure
     */
    public function setDeparturePlatformName(\StructType\NaturalLanguageStringStructure $departurePlatformName = null)
    {
        $this->DeparturePlatformName = $departurePlatformName;
        return $this;
    }
    /**
     * Get DepartureBoardingActivity value
     * @return string|null
     */
    public function getDepartureBoardingActivity()
    {
        return $this->DepartureBoardingActivity;
    }
    /**
     * Set DepartureBoardingActivity value
     * @uses \EnumType\DepartureBoardingActivityEnumeration::valueIsValid()
     * @uses \EnumType\DepartureBoardingActivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureBoardingActivity
     * @return \StructType\DatedCallStructure
     */
    public function setDepartureBoardingActivity($departureBoardingActivity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepartureBoardingActivityEnumeration::valueIsValid($departureBoardingActivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departureBoardingActivity, implode(', ', \EnumType\DepartureBoardingActivityEnumeration::getValidValues())), __LINE__);
        }
        $this->DepartureBoardingActivity = $departureBoardingActivity;
        return $this;
    }
    /**
     * Get DepartureStopAssignment value
     * @return \StructType\PlannedStopAssignmentStructure|null
     */
    public function getDepartureStopAssignment()
    {
        return $this->DepartureStopAssignment;
    }
    /**
     * Set DepartureStopAssignment value
     * @param \StructType\PlannedStopAssignmentStructure $departureStopAssignment
     * @return \StructType\DatedCallStructure
     */
    public function setDepartureStopAssignment(\StructType\PlannedStopAssignmentStructure $departureStopAssignment = null)
    {
        $this->DepartureStopAssignment = $departureStopAssignment;
        return $this;
    }
    /**
     * Get DepartureOperatorRefs value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getDepartureOperatorRefs()
    {
        return $this->DepartureOperatorRefs;
    }
    /**
     * Set DepartureOperatorRefs value
     * @param \StructType\OperatorRefStructure $departureOperatorRefs
     * @return \StructType\DatedCallStructure
     */
    public function setDepartureOperatorRefs(\StructType\OperatorRefStructure $departureOperatorRefs = null)
    {
        $this->DepartureOperatorRefs = $departureOperatorRefs;
        return $this;
    }
    /**
     * Get AimedLatestPassengerAccessTime value
     * @return string|null
     */
    public function getAimedLatestPassengerAccessTime()
    {
        return $this->AimedLatestPassengerAccessTime;
    }
    /**
     * Set AimedLatestPassengerAccessTime value
     * @param string $aimedLatestPassengerAccessTime
     * @return \StructType\DatedCallStructure
     */
    public function setAimedLatestPassengerAccessTime($aimedLatestPassengerAccessTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedLatestPassengerAccessTime) && !is_string($aimedLatestPassengerAccessTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedLatestPassengerAccessTime)), __LINE__);
        }
        $this->AimedLatestPassengerAccessTime = $aimedLatestPassengerAccessTime;
        return $this;
    }
    /**
     * Get AimedHeadwayInterval value
     * @return string|null
     */
    public function getAimedHeadwayInterval()
    {
        return $this->AimedHeadwayInterval;
    }
    /**
     * Set AimedHeadwayInterval value
     * @param string $aimedHeadwayInterval
     * @return \StructType\DatedCallStructure
     */
    public function setAimedHeadwayInterval($aimedHeadwayInterval = null)
    {
        // validation for constraint: string
        if (!is_null($aimedHeadwayInterval) && !is_string($aimedHeadwayInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedHeadwayInterval)), __LINE__);
        }
        $this->AimedHeadwayInterval = $aimedHeadwayInterval;
        return $this;
    }
    /**
     * Get TargetedInterchange value
     * @return \StructType\TargetedInterchangeStructure[]|null
     */
    public function getTargetedInterchange()
    {
        return $this->TargetedInterchange;
    }
    /**
     * Set TargetedInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\TargetedInterchangeStructure[] $targetedInterchange
     * @return \StructType\DatedCallStructure
     */
    public function setTargetedInterchange(array $targetedInterchange = array())
    {
        foreach ($targetedInterchange as $datedCallStructureTargetedInterchangeItem) {
            // validation for constraint: itemType
            if (!$datedCallStructureTargetedInterchangeItem instanceof \StructType\TargetedInterchangeStructure) {
                throw new \InvalidArgumentException(sprintf('The TargetedInterchange property can only contain items of \StructType\TargetedInterchangeStructure, "%s" given', is_object($datedCallStructureTargetedInterchangeItem) ? get_class($datedCallStructureTargetedInterchangeItem) : gettype($datedCallStructureTargetedInterchangeItem)), __LINE__);
            }
        }
        $this->TargetedInterchange = $targetedInterchange;
        return $this;
    }
    /**
     * Add item to TargetedInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\TargetedInterchangeStructure $item
     * @return \StructType\DatedCallStructure
     */
    public function addToTargetedInterchange(\StructType\TargetedInterchangeStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TargetedInterchangeStructure) {
            throw new \InvalidArgumentException(sprintf('The TargetedInterchange property can only contain items of \StructType\TargetedInterchangeStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TargetedInterchange[] = $item;
        return $this;
    }
    /**
     * Get FromServiceJourneyInterchange value
     * @return \StructType\FromServiceJourneyInterchangeStructure[]|null
     */
    public function getFromServiceJourneyInterchange()
    {
        return $this->FromServiceJourneyInterchange;
    }
    /**
     * Set FromServiceJourneyInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\FromServiceJourneyInterchangeStructure[] $fromServiceJourneyInterchange
     * @return \StructType\DatedCallStructure
     */
    public function setFromServiceJourneyInterchange(array $fromServiceJourneyInterchange = array())
    {
        foreach ($fromServiceJourneyInterchange as $datedCallStructureFromServiceJourneyInterchangeItem) {
            // validation for constraint: itemType
            if (!$datedCallStructureFromServiceJourneyInterchangeItem instanceof \StructType\FromServiceJourneyInterchangeStructure) {
                throw new \InvalidArgumentException(sprintf('The FromServiceJourneyInterchange property can only contain items of \StructType\FromServiceJourneyInterchangeStructure, "%s" given', is_object($datedCallStructureFromServiceJourneyInterchangeItem) ? get_class($datedCallStructureFromServiceJourneyInterchangeItem) : gettype($datedCallStructureFromServiceJourneyInterchangeItem)), __LINE__);
            }
        }
        $this->FromServiceJourneyInterchange = $fromServiceJourneyInterchange;
        return $this;
    }
    /**
     * Add item to FromServiceJourneyInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\FromServiceJourneyInterchangeStructure $item
     * @return \StructType\DatedCallStructure
     */
    public function addToFromServiceJourneyInterchange(\StructType\FromServiceJourneyInterchangeStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FromServiceJourneyInterchangeStructure) {
            throw new \InvalidArgumentException(sprintf('The FromServiceJourneyInterchange property can only contain items of \StructType\FromServiceJourneyInterchangeStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FromServiceJourneyInterchange[] = $item;
        return $this;
    }
    /**
     * Get ToServiceJourneyInterchange value
     * @return \StructType\ToServiceJourneyInterchangeStructure[]|null
     */
    public function getToServiceJourneyInterchange()
    {
        return $this->ToServiceJourneyInterchange;
    }
    /**
     * Set ToServiceJourneyInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\ToServiceJourneyInterchangeStructure[] $toServiceJourneyInterchange
     * @return \StructType\DatedCallStructure
     */
    public function setToServiceJourneyInterchange(array $toServiceJourneyInterchange = array())
    {
        foreach ($toServiceJourneyInterchange as $datedCallStructureToServiceJourneyInterchangeItem) {
            // validation for constraint: itemType
            if (!$datedCallStructureToServiceJourneyInterchangeItem instanceof \StructType\ToServiceJourneyInterchangeStructure) {
                throw new \InvalidArgumentException(sprintf('The ToServiceJourneyInterchange property can only contain items of \StructType\ToServiceJourneyInterchangeStructure, "%s" given', is_object($datedCallStructureToServiceJourneyInterchangeItem) ? get_class($datedCallStructureToServiceJourneyInterchangeItem) : gettype($datedCallStructureToServiceJourneyInterchangeItem)), __LINE__);
            }
        }
        $this->ToServiceJourneyInterchange = $toServiceJourneyInterchange;
        return $this;
    }
    /**
     * Add item to ToServiceJourneyInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\ToServiceJourneyInterchangeStructure $item
     * @return \StructType\DatedCallStructure
     */
    public function addToToServiceJourneyInterchange(\StructType\ToServiceJourneyInterchangeStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ToServiceJourneyInterchangeStructure) {
            throw new \InvalidArgumentException(sprintf('The ToServiceJourneyInterchange property can only contain items of \StructType\ToServiceJourneyInterchangeStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ToServiceJourneyInterchange[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\DatedCallStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatedCallStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
