<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataSupplyRequestBodyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Body of Data Supply Request. Used in WSDL.
 * @subpackage Structs
 */
class DataSupplyRequestBodyStructure extends AbstractStructBase
{
    /**
     * The NotificationRef
     * @var \StructType\MessageRefStructure
     */
    public $NotificationRef;
    /**
     * The AllData
     * @var bool
     */
    public $AllData;
    /**
     * Constructor method for DataSupplyRequestBodyStructure
     * @uses DataSupplyRequestBodyStructure::setNotificationRef()
     * @uses DataSupplyRequestBodyStructure::setAllData()
     * @param \StructType\MessageRefStructure $notificationRef
     * @param bool $allData
     */
    public function __construct(\StructType\MessageRefStructure $notificationRef = null, $allData = null)
    {
        $this
            ->setNotificationRef($notificationRef)
            ->setAllData($allData);
    }
    /**
     * Get NotificationRef value
     * @return \StructType\MessageRefStructure|null
     */
    public function getNotificationRef()
    {
        return $this->NotificationRef;
    }
    /**
     * Set NotificationRef value
     * @param \StructType\MessageRefStructure $notificationRef
     * @return \StructType\DataSupplyRequestBodyStructure
     */
    public function setNotificationRef(\StructType\MessageRefStructure $notificationRef = null)
    {
        $this->NotificationRef = $notificationRef;
        return $this;
    }
    /**
     * Get AllData value
     * @return bool|null
     */
    public function getAllData()
    {
        return $this->AllData;
    }
    /**
     * Set AllData value
     * @param bool $allData
     * @return \StructType\DataSupplyRequestBodyStructure
     */
    public function setAllData($allData = null)
    {
        // validation for constraint: boolean
        if (!is_null($allData) && !is_bool($allData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allData)), __LINE__);
        }
        $this->AllData = $allData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataSupplyRequestBodyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
