<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for D2LogicalModel StructType
 * @subpackage Structs
 */
class D2LogicalModel extends AbstractStructBase
{
    /**
     * The modelBaseVersion
     * Meta informations extracted from the WSDL
     * - fixed: 2.0RC1
     * - use: required
     * @var string
     */
    public $modelBaseVersion;
    /**
     * The exchange
     * @var \StructType\Exchange
     */
    public $exchange;
    /**
     * The payloadPublication
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PayloadPublication
     */
    public $payloadPublication;
    /**
     * The d2LogicalModelExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $d2LogicalModelExtension;
    /**
     * Constructor method for D2LogicalModel
     * @uses D2LogicalModel::setModelBaseVersion()
     * @uses D2LogicalModel::setExchange()
     * @uses D2LogicalModel::setPayloadPublication()
     * @uses D2LogicalModel::setD2LogicalModelExtension()
     * @param string $modelBaseVersion
     * @param \StructType\Exchange $exchange
     * @param \StructType\PayloadPublication $payloadPublication
     * @param \StructType\ExtensionType $d2LogicalModelExtension
     */
    public function __construct($modelBaseVersion = null, \StructType\Exchange $exchange = null, \StructType\PayloadPublication $payloadPublication = null, \StructType\ExtensionType $d2LogicalModelExtension = null)
    {
        $this
            ->setModelBaseVersion($modelBaseVersion)
            ->setExchange($exchange)
            ->setPayloadPublication($payloadPublication)
            ->setD2LogicalModelExtension($d2LogicalModelExtension);
    }
    /**
     * Get modelBaseVersion value
     * @return string
     */
    public function getModelBaseVersion()
    {
        return $this->modelBaseVersion;
    }
    /**
     * Set modelBaseVersion value
     * @param string $modelBaseVersion
     * @return \StructType\D2LogicalModel
     */
    public function setModelBaseVersion($modelBaseVersion = null)
    {
        // validation for constraint: string
        if (!is_null($modelBaseVersion) && !is_string($modelBaseVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelBaseVersion)), __LINE__);
        }
        $this->modelBaseVersion = $modelBaseVersion;
        return $this;
    }
    /**
     * Get exchange value
     * @return \StructType\Exchange|null
     */
    public function getExchange()
    {
        return $this->exchange;
    }
    /**
     * Set exchange value
     * @param \StructType\Exchange $exchange
     * @return \StructType\D2LogicalModel
     */
    public function setExchange(\StructType\Exchange $exchange = null)
    {
        $this->exchange = $exchange;
        return $this;
    }
    /**
     * Get payloadPublication value
     * @return \StructType\PayloadPublication|null
     */
    public function getPayloadPublication()
    {
        return $this->payloadPublication;
    }
    /**
     * Set payloadPublication value
     * @param \StructType\PayloadPublication $payloadPublication
     * @return \StructType\D2LogicalModel
     */
    public function setPayloadPublication(\StructType\PayloadPublication $payloadPublication = null)
    {
        $this->payloadPublication = $payloadPublication;
        return $this;
    }
    /**
     * Get d2LogicalModelExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getD2LogicalModelExtension()
    {
        return $this->d2LogicalModelExtension;
    }
    /**
     * Set d2LogicalModelExtension value
     * @param \StructType\ExtensionType $d2LogicalModelExtension
     * @return \StructType\D2LogicalModel
     */
    public function setD2LogicalModelExtension(\StructType\ExtensionType $d2LogicalModelExtension = null)
    {
        $this->d2LogicalModelExtension = $d2LogicalModelExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\D2LogicalModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
